/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms;

import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.AntPath;
import org.marsik.ham.adif.enums.Propagation;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.comms.CommsLinkGenerator;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.comms.InternetPropagation;
import uk.m0nom.adifproc.comms.SatellitePropagationService;
import uk.m0nom.adifproc.comms.TroposphericDuctingPropagation;
import uk.m0nom.adifproc.comms.ionosphere.LongPath;
import uk.m0nom.adifproc.comms.ionosphere.ShortPath;
import uk.m0nom.adifproc.coords.GlobalCoords3D;

@Service
public class CommsVisualizationService
implements CommsLinkGenerator {
    private final SatellitePropagationService satellitePropagationService;

    public CommsVisualizationService(SatellitePropagationService satellitePropagationService) {
        this.satellitePropagationService = satellitePropagationService;
    }

    @Override
    public CommsLinkResult getCommunicationsLink(TransformControl control, GlobalCoords3D startGc, GlobalCoords3D endGc, Adif3Record rec) {
        CommsLinkResult result = null;
        boolean unsupportedPropagationMode = false;
        Propagation overridenPropagationMode = rec.getPropMode();
        Propagation propagationModeOverride = Propagation.F2_REFLECTION;
        if (rec.getPropMode() != null) {
            switch (rec.getPropMode()) {
                case INTERNET: {
                    result = new InternetPropagation().getCommunicationsLink(control, startGc, endGc, rec);
                    break;
                }
                case SATELLITE: {
                    result = this.satellitePropagationService.getCommunicationsLink(control, startGc, endGc, rec);
                    break;
                }
                case TROPOSPHERIC_DUCTING: {
                    result = new TroposphericDuctingPropagation().getCommunicationsLink(control, startGc, endGc, rec);
                    break;
                }
                case F2_REFLECTION: {
                    break;
                }
                default: {
                    unsupportedPropagationMode = true;
                }
            }
        }
        if (unsupportedPropagationMode) {
            rec.setPropMode(propagationModeOverride);
        }
        if (result == null) {
            result = rec.getAntPath() == AntPath.LONG ? new LongPath().getCommunicationsLink(control, startGc, endGc, rec) : new ShortPath().getCommunicationsLink(control, startGc, endGc, rec);
        }
        if (unsupportedPropagationMode) {
            result.setUnsupportedPropagationMode(true);
            result.setUnsupportedPropagation(overridenPropagationMode);
        }
        return result;
    }
}

