/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.contest;

import java.util.ArrayList;
import java.util.Collection;
import org.marsik.ham.adif.Adif3;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.contest.ContestResultCalculator;
import uk.m0nom.adifproc.contest.HappyCamperResultsCalculator;
import uk.m0nom.adifproc.contest.JackOfAllTradesResultCalculator;
import uk.m0nom.adifproc.contest.LakeDistrictLoverResultsCalculator;
import uk.m0nom.adifproc.contest.LongDistanceRelationshipContestCalculator;
import uk.m0nom.adifproc.contest.ManicTouristResultsCalculator;

public class ContestResultsCalculator {
    private final Collection<ContestResultCalculator> calculators;
    private final ActivityDatabaseService databases;

    public ContestResultsCalculator(ActivityDatabaseService databases) {
        this.databases = databases;
        this.calculators = new ArrayList<ContestResultCalculator>();
        this.calculators.add(new LongDistanceRelationshipContestCalculator());
        this.calculators.add(new HappyCamperResultsCalculator());
        this.calculators.add(new ManicTouristResultsCalculator());
        this.calculators.add(new LakeDistrictLoverResultsCalculator());
        this.calculators.add(new JackOfAllTradesResultCalculator());
    }

    public String calculateResults(Adif3 log) {
        StringBuilder results = new StringBuilder();
        int i = 0;
        for (ContestResultCalculator calculator : this.calculators) {
            results.append(calculator.formatResult(calculator.calculateResult(this.databases, log)));
            if (++i < this.calculators.size()) {
                results.append(", ");
                continue;
            }
            results.append("\n");
        }
        return results.toString();
    }
}

