/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.IrishGridParser5Digit;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationFormatter;
import uk.m0nom.adifproc.coords.LocationInfo;
import uk.m0nom.adifproc.coords.LocationParser;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.irishgrid.IrishGridConverter;
import uk.m0nom.adifproc.irishgrid.IrishGridConverterResult;
import uk.m0nom.adifproc.osgb36.OsGb36Converter;
import uk.m0nom.adifproc.osgb36.OsGb36ConverterResult;

public class WabParser
implements LocationParser,
LocationFormatter {
    private static final Pattern PATTERN = Pattern.compile("^([CDHJ]|[A-Z]{2})\\s*([0-9])\\s*([0-9])$");

    @Override
    public Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public GlobalCoords3D parse(LocationSource source, String locationString) {
        Matcher matcher = this.getPattern().matcher(locationString);
        if (matcher.find()) {
            String map = matcher.group(1);
            String easting = matcher.group(2);
            String northing = matcher.group(3);
            if (map.length() == 1) {
                String locator = String.format("%s%s%s%s%s", map, easting, "5555", northing, "5555");
                IrishGridParser5Digit converter = new IrishGridParser5Digit();
                return converter.parse(LocationSource.WAB, locator);
            }
            String locator = String.format("%s%s%s%s%s", map, easting, "5555", northing, "5555");
            OsGb36Converter converter = new OsGb36Converter();
            OsGb36ConverterResult result = converter.convertOsGb36ToCoords(locator);
            return new GlobalCoords3D(result.getCoords(), (Double)0.0, new LocationInfo(LocationAccuracy.WAB, LocationSource.WAB));
        }
        return null;
    }

    @Override
    public String format(GlobalCoordinates coords) {
        IrishGridConverter irishConverter = new IrishGridConverter();
        IrishGridConverterResult irishResult = irishConverter.convertCoordsToIrishGridRef(coords);
        if (irishResult.isSuccess()) {
            String gridRef = irishResult.getIrishGridRef();
            return String.format("WAB: %s%s%s", gridRef.substring(0, 1), gridRef.substring(2, 3), gridRef.substring(8, 9));
        }
        OsGb36Converter converter = new OsGb36Converter();
        OsGb36ConverterResult result = converter.convertCoordsToOsGb36(coords);
        if (result.isSuccess()) {
            String loc = result.getOsGb36();
            return String.format("WAB: %s%s%s", loc.substring(0, 2), loc.substring(2, 3), loc.substring(7, 8));
        }
        return "WAB Square: undefined";
    }

    @Override
    public String getName() {
        return "WAB Square";
    }
}

