/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.dxcc;

import java.text.ParseException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.marsik.ham.adif.Adif3Record;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.callsign.CallsignUtils;
import uk.m0nom.adifproc.dxcc.DxccEntity;
import uk.m0nom.adifproc.dxcc.DxccPermutations;
import uk.m0nom.adifproc.dxcc.JsonDxccEntities;
import uk.m0nom.adifproc.dxcc.JsonDxccEntity;

public class DxccEntities {
    private Collection<DxccEntity> dxccEntities = new ArrayList<DxccEntity>();
    private Map<Integer, DxccEntity> dxccEntityMap = new HashMap<Integer, DxccEntity>();

    public void setup(JsonDxccEntities rawDxccEntities) throws ParseException {
        for (JsonDxccEntity dxcc : rawDxccEntities.getRawDxccEntities()) {
            DxccEntity entity = new DxccEntity(dxcc);
            this.dxccEntities.add(entity);
            this.dxccEntityMap.put(entity.getEntityCode(), entity);
            entity.setPrefixes(this.getPrefixesForDxccEntity(entity));
        }
    }

    public DxccEntity getDxccEntity(int entityCode) {
        return this.dxccEntityMap.get(entityCode);
    }

    public Collection<DxccEntity> findEntitiesFromPrefix(String prefix, ZonedDateTime qsoDate) {
        return this.dxccEntities.stream().filter(entity -> entity.isValidForDate(qsoDate)).filter(entity -> Pattern.compile(entity.getPrefixRegex()).matcher(prefix.toUpperCase()).matches()).collect(Collectors.toCollection(ArrayList::new));
    }

    private DxccEntity tryFindEntitiesForSuffix(String callsign, ZonedDateTime qsoDate) {
        String swappedCallsign = CallsignUtils.swapSuffixToPrefix(callsign);
        Collection<DxccEntity> matches = this.findEntitiesFromPrefix(swappedCallsign, qsoDate);
        return switch (matches.size()) {
            case 1 -> matches.iterator().next();
            case 2 -> this.bestMatch(swappedCallsign, matches);
            default -> null;
        };
    }

    public DxccEntity findDxccEntityFromCallsign(String callsign, ZonedDateTime qsoDate) {
        if (CallsignUtils.doesCallsignHaveNonStandardSuffix(callsign)) {
            return this.tryFindEntitiesForSuffix(callsign, qsoDate);
        }
        Collection<DxccEntity> matches = this.findEntitiesFromPrefix(callsign, qsoDate);
        return switch (matches.size()) {
            case 0 -> null;
            case 1 -> matches.iterator().next();
            default -> this.bestMatch(callsign, matches);
        };
    }

    public Collection<String> getPrefixesForDxccEntity(DxccEntity entity) {
        String[] prefixes;
        ArrayList<String> prefixesToCheck = new ArrayList<String>();
        String prefixList = entity.getPrefix();
        for (String prefix : prefixes = prefixList.split(",")) {
            if (prefix.contains("-")) {
                Collection<String> range;
                String[] rangePrefixes = prefix.split("-");
                if (rangePrefixes.length == 2) {
                    range = new ArrayList<String>(DxccPermutations.generate(rangePrefixes[0], rangePrefixes[1]));
                    prefixesToCheck.addAll(range);
                    continue;
                }
                if (rangePrefixes.length != 3) continue;
                range = this.processComplexPrefixSpecification(rangePrefixes);
                prefixesToCheck.addAll(range);
                continue;
            }
            prefixesToCheck.add(prefix);
        }
        return prefixesToCheck;
    }

    private DxccEntity bestMatch(String callsign, Collection<DxccEntity> entities) {
        HashMap<String, DxccEntity> prefixesToCheck = new HashMap<String, DxccEntity>();
        for (DxccEntity entity : entities) {
            Collection<String> prefixes = this.getPrefixesForDxccEntity(entity);
            for (String prefix : prefixes) {
                prefixesToCheck.put(prefix, entity);
            }
        }
        return this.checkForLongestMatchingPrefix(callsign, prefixesToCheck);
    }

    public Collection<String> processComplexPrefixSpecification(String[] rangePrefixes) {
        ArrayList<String> prefixes = new ArrayList<String>();
        if (rangePrefixes.length == 3) {
            String outPrefixLeft = rangePrefixes[0];
            String outPrefixRight = rangePrefixes[1].substring(0, outPrefixLeft.length());
            ArrayList<String> outPrefixes = new ArrayList<String>(DxccPermutations.generate(outPrefixLeft, outPrefixRight));
            String inPrefixRight = rangePrefixes[2];
            String inPrefixLeft = rangePrefixes[1].substring(rangePrefixes[1].length() - inPrefixRight.length());
            ArrayList<String> inPrefixes = new ArrayList<String>();
            if (inPrefixRight.equals("0")) {
                inPrefixes.addAll(this.getSpecialRangEndingIn0(inPrefixLeft));
            } else {
                inPrefixes.addAll(DxccPermutations.generate(inPrefixLeft, inPrefixRight));
            }
            for (String outPrefix : outPrefixes) {
                for (String inPrefix : inPrefixes) {
                    prefixes.add(outPrefix.concat(inPrefix));
                }
            }
        }
        return prefixes;
    }

    private Collection<String> getSpecialRangEndingIn0(String inPrefixLeft) {
        ArrayList<String> prefixes = new ArrayList<String>();
        int left = Integer.parseInt(inPrefixLeft);
        while (left < 10) {
            prefixes.add(Integer.toString(left++));
        }
        prefixes.add("0");
        return prefixes;
    }

    private Collection<String> getRangeOfPrefixes(String[] rangePrefixes) {
        ArrayList<String> range = new ArrayList<String>(DxccPermutations.generate(rangePrefixes[0], rangePrefixes[1]));
        return new ArrayList<String>(range);
    }

    private DxccEntity checkForLongestMatchingPrefix(String callsign, Map<String, DxccEntity> prefixesToCheck) {
        String longestPrefix = "";
        for (String prefix : prefixesToCheck.keySet()) {
            if (!callsign.startsWith(prefix) || prefix.length() <= longestPrefix.length()) continue;
            longestPrefix = prefix;
        }
        return prefixesToCheck.get(longestPrefix);
    }

    public void setFromDxccEntity(Qso qso, TransformControl control) {
        Adif3Record rec = qso.getRecord();
        if (rec.getMyDxcc() != null) {
            qso.getFrom().setDxccEntity(control.getDxccEntities().getDxccEntity(rec.getMyDxcc()));
        } else {
            qso.getFrom().setDxccEntity(control.getDxccEntities().findDxccEntityFromCallsign(qso.getFrom().getCallsign(), qso.getRecord().getQsoDate()));
        }
    }

    public void setToDxccEntity(Qso qso, TransformControl control) {
        Adif3Record rec = qso.getRecord();
        if (rec.getDxcc() != null) {
            qso.getTo().setDxccEntity(control.getDxccEntities().getDxccEntity(rec.getDxcc()));
        } else {
            qso.getTo().setDxccEntity(control.getDxccEntities().findDxccEntityFromCallsign(qso.getTo().getCallsign(), qso.getRecord().getQsoDate()));
        }
    }

    public Collection<DxccEntity> getDxccEntities() {
        return this.dxccEntities;
    }

    public Map<Integer, DxccEntity> getDxccEntityMap() {
        return this.dxccEntityMap;
    }

    public void setDxccEntities(Collection<DxccEntity> dxccEntities) {
        this.dxccEntities = dxccEntities;
    }

    public void setDxccEntityMap(Map<Integer, DxccEntity> dxccEntityMap) {
        this.dxccEntityMap = dxccEntityMap;
    }
}

