/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.geocoding;

import fr.dudie.nominatim.client.JsonNominatimClient;
import fr.dudie.nominatim.model.Address;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.geocoding.GeocodingCache;
import uk.m0nom.adifproc.geocoding.GeocodingProvider;
import uk.m0nom.adifproc.geocoding.GeocodingResult;
import uk.m0nom.adifproc.qrz.QrzCallsign;

@Service
public class NominatimGeocodingProvider
implements GeocodingProvider {
    private static final long DELAY = 1000L;
    private static final Logger logger = Logger.getLogger(NominatimGeocodingProvider.class.getName());
    private long lastTimestamp = Instant.now().toEpochMilli();
    private static final GeocodingCache cache = new GeocodingCache();

    @Override
    public GeocodingResult getLocationFromAddress(QrzCallsign qrzData) throws IOException, InterruptedException {
        GeocodingResult result = null;
        String addressToCheck = this.addressStringFromQrzData(qrzData);
        if (addressToCheck != null) {
            result = cache.get(addressToCheck);
            if (result == null) {
                result = this.queryUsingAddressSubstring(qrzData.getCall(), addressToCheck);
                cache.put(addressToCheck, result);
            } else {
                logger.info(String.format("Geocoding cache hit for address: %s", addressToCheck));
            }
        }
        return result;
    }

    @Override
    public GeocodingResult getLocationFromAddress(String address) throws IOException, InterruptedException {
        return this.queryUsingAddressSubstring("CoordinateConverterController", address);
    }

    private String addressStringFromQrzData(QrzCallsign qrzData) {
        String addressToCheck = null;
        String searchString = "";
        searchString = this.addIfNotNull(searchString, qrzData.getAddr1());
        searchString = this.addIfNotNull(searchString, qrzData.getAddr2());
        searchString = this.addIfNotNull(searchString, qrzData.getCounty());
        if ((searchString = this.addIfNotNull(searchString, qrzData.getCountry())).length() > 2) {
            searchString = searchString.substring(2);
            addressToCheck = searchString.replace(",,", ",");
        }
        return addressToCheck;
    }

    private GeocodingResult queryUsingAddressSubstring(String callsign, String addressToCheck) throws IOException, InterruptedException {
        String substring = addressToCheck;
        GlobalCoords3D coords = null;
        int accuracy = 0;
        while (StringUtils.isNotBlank((CharSequence)substring) && coords == null) {
            if ((coords = this.addressSearch(callsign, substring, accuracy++)) != null) continue;
            String newSubstring = StringUtils.trim((String)substring.substring(substring.indexOf(44) + 1));
            if (StringUtils.equals((CharSequence)newSubstring, (CharSequence)substring)) {
                return new GeocodingResult(null, substring, "No location found");
            }
            substring = newSubstring;
        }
        return new GeocodingResult(coords, substring, null);
    }

    private GlobalCoords3D addressSearch(String callsign, String searchString, int accuracy) throws IOException, InterruptedException {
        long timeDiff = new Date().getTime() - this.lastTimestamp;
        if (timeDiff < 1000L) {
            long pause = 1000L - timeDiff;
            Thread.sleep(pause);
        }
        logger.info(String.format("Searching for a location for %s based on address search string: %s", callsign, searchString));
        List addressMatches = new JsonNominatimClient((HttpClient)HttpClientBuilder.create().build(), "mark@wickensonline.co.uk").search(StringUtils.trim((String)searchString));
        this.lastTimestamp = Instant.now().toEpochMilli();
        if (!addressMatches.isEmpty()) {
            Address match = (Address)addressMatches.get(0);
            LocationAccuracy locationAccuracy = this.getLocationAccuracy(accuracy);
            return new GlobalCoords3D(match.getLatitude(), match.getLongitude(), LocationSource.GEOCODING, locationAccuracy);
        }
        return null;
    }

    private LocationAccuracy getLocationAccuracy(int accuracy) {
        if (accuracy == 0) {
            return LocationAccuracy.GEOLOCATION_VERY_GOOD;
        }
        if (accuracy == 1) {
            return LocationAccuracy.GEOLOCATION_GOOD;
        }
        if (accuracy == 2) {
            return LocationAccuracy.GEOLOCATION_POOR;
        }
        return LocationAccuracy.GEOLOCATION_VERY_POOR;
    }

    private String addIfNotNull(String current, String toAdd) {
        if (StringUtils.isNotEmpty((CharSequence)toAdd)) {
            return StringUtils.trim((String)(current + ", " + toAdd));
        }
        return current;
    }
}

