/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.info;

import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.AntPath;
import org.marsik.ham.adif.enums.Propagation;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.kml.info.KmlBaseInfoPanel;
import uk.m0nom.adifproc.kml.station.KmlStationUtils;

public class KmlContactInfoPanel
extends KmlBaseInfoPanel {
    public String getPanelContentForCommsLink(Qso qso, CommsLinkResult result, TemplateEngine templateEngine) {
        Adif3Record rec = qso.getRecord();
        Context context = new Context();
        this.setBaseInfo(rec, context, result);
        context.setVariable("qsoDate", (Object)KmlStationUtils.getQsoDateAsDisplayString(qso));
        if (qso.getRecord().getTimeOn() != null) {
            context.setVariable("timeOn", (Object)KmlStationUtils.getQsoTimeOnAsString(qso));
        }
        if (qso.getRecord().getTimeOff() != null) {
            context.setVariable("timeOff", (Object)KmlStationUtils.getQsoTimeOffAsString(qso));
        }
        context.setVariable("call", (Object)rec.getCall());
        context.setVariable("stationCallsign", (Object)rec.getStationCallsign());
        if (qso.getTo().getQrzInfo() != null) {
            context.setVariable("callForQrz", (Object)qso.getTo().getQrzInfo().getCall());
        } else {
            context.setVariable("callForQrz", (Object)rec.getCall());
        }
        if (qso.getFrom().getQrzInfo() != null) {
            context.setVariable("stationCallsignForQrz", (Object)qso.getFrom().getQrzInfo().getCall());
        } else {
            context.setVariable("stationCallsignForQrz", (Object)rec.getStationCallsign());
        }
        context.setVariable("azimuth", (Object)String.format("%03.03f", result.getAzimuth()));
        if (result.getPropagation() != null) {
            switch (result.getPropagation()) {
                case F2_REFLECTION: {
                    context.setVariable("skyDist", (Object)String.format("%,.0f", result.getSkyDistance()));
                    context.setVariable("bounces", (Object)String.format("%d", result.getBounces()));
                    context.setVariable("antPath", (Object)(rec.getAntPath() == null ? AntPath.SHORT : rec.getAntPath()));
                    break;
                }
                case SATELLITE: {
                    context.setVariable("satName", (Object)qso.getRecord().getSatName());
                    context.setVariable("satAlt", (Object)String.format("%,.0f km", result.getAltitude() / 1000.0));
                    break;
                }
                case TROPOSPHERIC_DUCTING: {
                    context.setVariable("bounces", (Object)String.format("%d", result.getBounces()));
                    context.setVariable("ductTop", (Object)String.format("%,.0f", result.getAltitude()));
                    context.setVariable("ductBase", (Object)String.format("%,.0f", result.getBase()));
                }
            }
        }
        if (result.getAltitude() > 9999.99) {
            context.setVariable("avgAlt", (Object)String.format("%,.0f km", result.getAltitude() / 1000.0));
        } else if (result.getPropagation() != Propagation.INTERNET) {
            context.setVariable("avgAlt", (Object)String.format("%,.0f metres", result.getAltitude()));
        }
        if (result.getPropagation() != Propagation.INTERNET) {
            context.setVariable("fromAntenna", (Object)qso.getFrom().getAntenna().getName());
        }
        if (result.getPropagation() == Propagation.F2_REFLECTION) {
            context.setVariable("fromAntennaMaxPowerAngle", (Object)String.format("%.0f\u00b0", qso.getFrom().getAntenna().getTakeOffAngle()));
        }
        context.setVariable("angle", (Object)String.format("%,.0f\u00b0", result.getFromAngle()));
        String mode = result.getPropagation() != null ? result.getPropagation().adifCode() : "GND";
        context.setVariable("propagationMode", (Object)mode);
        String html = templateEngine.process(new TemplateSpec("KmlContactInfo", TemplateMode.XML), (IContext)context);
        return html.replace("\n", "");
    }
}

