/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.station;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Style;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.Band;
import org.marsik.ham.adif.enums.Mode;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.icons.IconResource;
import uk.m0nom.adifproc.kml.KmlUtils;
import uk.m0nom.adifproc.kml.info.KmlStationInfoPanel;

public class KmlStationUtils {
    public static final double DEFAULT_RANGE_METRES = 500.0;
    private static final DateTimeFormatter serialDateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter displayDateFormatter = DateTimeFormatter.ofPattern("dd-MMM-yyyy");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm");
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter timeWithSecondsFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final String UNKNOWN_DATE_TIME = "unknown";
    private final Set<String> iconStyles = new HashSet<String>();
    private final TransformControl control;

    public KmlStationUtils(TransformControl control) {
        this.control = control;
    }

    public String addMyStationToMap(Document doc, Folder folder, Qso qso) {
        return this.createMyStationMarker(doc, folder, qso);
    }

    public static String getQsoDateTimeAsString(Qso qso) {
        ZonedDateTime date = qso.getRecord().getQsoDate();
        if (date != null) {
            LocalTime time = qso.getRecord().getTimeOn();
            ZonedDateTime utcDateTime = date;
            if (time != null) {
                utcDateTime = date.with(time);
            }
            return dateTimeFormatter.format(utcDateTime);
        }
        System.out.printf("ERROR: QSO with %s has no date%n", qso.getTo().getCallsign());
        return UNKNOWN_DATE_TIME;
    }

    public static String getQsoDateAsSerialString(Qso qso) {
        ZonedDateTime date = qso.getRecord().getQsoDate();
        if (date != null) {
            return serialDateFormatter.format(date);
        }
        return UNKNOWN_DATE_TIME;
    }

    public static String getQsoDateAsDisplayString(Qso qso) {
        ZonedDateTime date = qso.getRecord().getQsoDate();
        if (date != null) {
            return displayDateFormatter.format(date);
        }
        return UNKNOWN_DATE_TIME;
    }

    public static String getQsoTimeOnAsString(Qso qso) {
        LocalTime time = qso.getRecord().getTimeOn();
        if (time != null) {
            return timeFormatter.format(time);
        }
        return null;
    }

    public static String getQsoTimeOffAsString(Qso qso) {
        LocalTime time = qso.getRecord().getTimeOff();
        if (time != null) {
            return timeFormatter.format(time);
        }
        return UNKNOWN_DATE_TIME;
    }

    public String createMyStationMarker(Document document, Folder folder, Qso qso) {
        String id = KmlStationUtils.getStationMarkerId(qso, qso.getFrom());
        Adif3Record rec = qso.getRecord();
        GlobalCoordinates coords = rec.getMyCoordinates();
        if (qso.getFrom().getCoordinates() == null && coords == null) {
            return String.format("Cannot determine coordinates for station %s, please specify a location override", qso.getFrom().getCallsign());
        }
        double longitude = coords.getLongitude();
        double latitude = coords.getLatitude();
        double altitude = rec.getMyAltitude() != null ? rec.getMyAltitude() : 0.0;
        String callsign = qso.getFrom().getCallsign();
        Folder myFolder = folder.createAndAddFolder().withName(callsign).withOpen(Boolean.valueOf(false));
        IconResource icon = IconResource.getMyIconFromStation(this.control, qso.getFrom());
        if (!this.iconStyles.contains(icon.getName())) {
            Icon kmlIcon = new Icon().withHref(icon.getUrl());
            Style style = document.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
            style.createAndSetIconStyle().withScale(1.0).withIcon(kmlIcon);
            style.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
            this.iconStyles.add(icon.getName());
        }
        Placemark placemark = myFolder.createAndAddPlacemark();
        String htmlPanelContent = new KmlStationInfoPanel().getPanelContentForStation(this.control, qso.getFrom(), null);
        placemark.withName(callsign).withStyleUrl(KmlUtils.getStyleUrl(icon.getName())).withDescription(htmlPanelContent).createAndSetLookAt().withLongitude(longitude).withLatitude(latitude).withAltitude(altitude).withRange(500.0);
        placemark.createAndSetPoint().addToCoordinates(longitude, latitude);
        if (this.control.isKmlShowActivitySubLabel()) {
            this.addActivitySubLabel(qso.getFrom(), document, folder, longitude, latitude, altitude, id);
        } else if (this.control.isKmlShowStationSubLabel()) {
            this.addStationSubLabel(qso.getRecord().getBand(), qso.getRecord().getMode(), document, folder, longitude, latitude, altitude, id);
        }
        return null;
    }

    public void createSatelliteContactMarker(TransformControl control, Document document, Folder folder, Qso qso, GlobalCoords3D position, String description) {
        String name = KmlStationUtils.getSatelliteMarkerName(qso);
        String folderName = KmlStationUtils.getSatelliteFolderName(qso);
        IconResource icon = IconResource.getSatelliteResource(control);
        if (!this.iconStyles.contains(icon.getName())) {
            Icon kmlIcon = new Icon().withHref(icon.getUrl());
            Style style = document.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
            style.createAndSetIconStyle().withScale(1.0).withIcon(kmlIcon);
            style.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
            this.iconStyles.add(icon.getName());
        }
        Folder satFolder = folder.createAndAddFolder().withName(folderName).withOpen(Boolean.valueOf(false));
        Placemark placemark = satFolder.createAndAddPlacemark().withDescription(description);
        placemark.withName(name).withStyleUrl(KmlUtils.getStyleUrl(icon.getName())).createAndSetLookAt().withLongitude(position.getLongitude()).withLatitude(position.getLatitude()).withAltitude(position.getAltitude().doubleValue()).withRange(500.0);
        placemark.createAndSetPoint().addToCoordinates(position.getLongitude(), position.getLatitude(), position.getAltitude().doubleValue()).setAltitudeMode(AltitudeMode.ABSOLUTE);
    }

    public String createStationMarker(TransformControl control, Document document, Folder folder, Qso qso, CommsLinkResult result) {
        String id = KmlStationUtils.getStationMarkerId(qso, qso.getTo());
        String name = KmlStationUtils.getStationMarkerName(qso);
        Adif3Record rec = qso.getRecord();
        if (qso.getTo().getCoordinates() == null && rec.getCoordinates() == null) {
            return String.format("Cannot determine coordinates for station %s, please specify a location override", qso.getFrom().getCallsign());
        }
        GlobalCoordinates myCoords = rec.getMyCoordinates();
        double myLatitude = myCoords.getLatitude();
        double myLongitude = myCoords.getLongitude();
        GlobalCoordinates coords = rec.getCoordinates();
        double longitude = coords.getLongitude();
        double latitude = coords.getLatitude();
        double altitude = rec.getAltitude() != null ? rec.getAltitude() : 0.0;
        IconResource icon = IconResource.getIconFromStation(control, qso.getTo());
        if (!this.iconStyles.contains(icon.getName())) {
            Icon kmlIcon = new Icon().withHref(icon.getUrl());
            Style style = document.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
            style.createAndSetIconStyle().withScale(1.0).withIcon(kmlIcon);
            style.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
            style.createAndSetLineStyle().withColor("ffb343ff").withWidth(5.0);
            this.iconStyles.add(icon.getName());
        }
        Placemark placemark = folder.createAndAddPlacemark();
        String htmlPanelContent = new KmlStationInfoPanel().getPanelContentForStation(control, qso.getTo(), result);
        placemark.withName(name).withId(id).withStyleUrl(KmlUtils.getStyleUrl(icon.getName())).withDescription(htmlPanelContent).createAndSetLookAt().withLongitude(longitude).withLatitude(latitude).withAltitude(altitude).withRange(500.0);
        placemark.createAndSetLineString().addToCoordinates(myLongitude, myLatitude).addToCoordinates(longitude, latitude).setExtrude(Boolean.valueOf(true));
        placemark.createAndSetPoint().addToCoordinates(longitude, latitude, altitude);
        if (altitude > 0.0) {
            placemark.createAndSetPoint().addToCoordinates(longitude, latitude, altitude).setAltitudeMode(AltitudeMode.ABSOLUTE);
        } else {
            placemark.createAndSetPoint().addToCoordinates(longitude, latitude, altitude);
        }
        if (control.isKmlShowActivitySubLabel()) {
            this.addActivitySubLabel(qso.getTo(), document, folder, longitude, latitude, altitude, id);
        } else if (control.isKmlShowStationSubLabel()) {
            this.addStationSubLabel(qso.getRecord().getBand(), qso.getRecord().getMode(), document, folder, longitude, latitude, altitude, id);
        }
        return null;
    }

    private void addStationSubLabel(Band band, Mode mode, Document document, Folder folder, double longitude, double latitude, double altitude, String id) {
        IconResource icon = IconResource.getIconFromMode(this.control, mode);
        String modeId = mode.name();
        if (icon != null) {
            if (!this.iconStyles.contains(modeId)) {
                Icon modeIcon = new Icon().withHref(icon.getUrl());
                Style modeStyle = document.createAndAddStyle().withId(KmlUtils.getModeStyleId(modeId));
                modeStyle.createAndSetIconStyle().withScale(1.0).withIcon(modeIcon);
                modeStyle.createAndSetLabelStyle().withColor("ff43b3ff").withScale(0.75);
                modeStyle.createAndSetLineStyle().withColor("ffb343ff").withWidth(3.0);
                this.iconStyles.add(modeId);
            }
            Placemark modePlaceMark = folder.createAndAddPlacemark();
            modePlaceMark.withId(KmlUtils.getModeId(id)).withName(KmlStationUtils.getModeLabel(band, mode)).withStyleUrl(KmlUtils.getModeStyleUrl(modeId));
            if (altitude > 0.0) {
                modePlaceMark.createAndSetPoint().addToCoordinates(longitude, latitude, altitude).setAltitudeMode(AltitudeMode.ABSOLUTE);
            } else {
                modePlaceMark.createAndSetPoint().addToCoordinates(longitude, latitude, altitude);
            }
        }
    }

    private void addActivitySubLabel(Station station, Document document, Folder folder, double longitude, double latitude, double altitude, String id) {
        IconResource icon = IconResource.getActivityIcon();
        if (!this.iconStyles.contains(icon.getName())) {
            Icon modeIcon = new Icon().withHref(icon.getUrl());
            Style activityStyle = document.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
            activityStyle.createAndSetIconStyle().withScale(1.0).withIcon(modeIcon);
            activityStyle.createAndSetLabelStyle().withColor("ff43b3ff").withScale(0.75);
            activityStyle.createAndSetLineStyle().withColor("ffb343ff").withWidth(3.0);
            this.iconStyles.add(icon.getName());
        }
        Placemark activityPlaceMark = folder.createAndAddPlacemark();
        activityPlaceMark.withId(KmlUtils.getModeId(id)).withName(KmlStationUtils.getActivityLabel(station)).withStyleUrl(KmlUtils.getStyleUrl(icon.getName()));
        if (altitude > 0.0) {
            activityPlaceMark.createAndSetPoint().addToCoordinates(longitude, latitude, altitude).setAltitudeMode(AltitudeMode.ABSOLUTE);
        } else {
            activityPlaceMark.createAndSetPoint().addToCoordinates(longitude, latitude, altitude);
        }
    }

    public static String getModeLabel(Band band, Mode mode) {
        if (band != null && mode != null) {
            return String.format("%s %s", band.adifCode(), mode.adifCode());
        }
        return "";
    }

    public static String getActivityLabel(Station station) {
        return station.getActivities().stream().map(Activity::getRef).collect(Collectors.joining(", "));
    }

    public static String getStationMarkerId(Qso qso, Station station) {
        String stationName = station.getCallsign();
        String dateTime = KmlStationUtils.getQsoDateTimeAsString(qso);
        String id = String.format("%s %s", dateTime, stationName);
        return id.replaceAll(" ", "_");
    }

    public static String getStationMarkerName(Qso qso) {
        return qso.getTo().getCallsign();
    }

    public static String getSatelliteFolderName(Qso qso) {
        String date = KmlStationUtils.getQsoDateAsSerialString(qso);
        String satelliteName = qso.getRecord().getSatName();
        return String.format("%s %s", date, satelliteName);
    }

    public static String getSatelliteMarkerName(Qso qso) {
        LocalTime time = qso.getRecord().getTimeOn();
        return timeWithSecondsFormatter.format(time);
    }
}

