/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.qrz;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.callsign.Callsign;
import uk.m0nom.adifproc.callsign.CallsignUtils;
import uk.m0nom.adifproc.qrz.QrzCallsign;
import uk.m0nom.adifproc.qrz.QrzDatabase;
import uk.m0nom.adifproc.qrz.QrzService;

@Service(value="qrzXmlService")
public class QrzXmlService
implements QrzService {
    private static final Logger logger = Logger.getLogger(QrzXmlService.class.getName());
    private static final String QRZ_XML_SERVICE_BASE_URL = " https://xmldata.qrz.com/xml";
    private static final String QRZ_XML_SERVICE_VERSION = "current";
    private static final long DELAY = 100L;
    private final OkHttpClient client = new OkHttpClient();
    private String sessionKey = null;
    private String username;
    private String password;
    private long lastTimestamp;

    @Override
    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean hasCredentials() {
        return !Strings.isEmpty((CharSequence)this.username) && !Strings.isEmpty((CharSequence)this.password);
    }

    @Override
    public boolean refreshSessionKey() {
        if (this.hasCredentials()) {
            String url = String.format("%s/%s/?username=%s&password=%s&agent=adifproc1.1", QRZ_XML_SERVICE_BASE_URL, QRZ_XML_SERVICE_VERSION, this.username, this.password);
            logger.info("Obtaining QRZ.COM session key");
            QrzDatabase database = this.runQuery(url);
            if (database != null) {
                this.sessionKey = database.getSession().getKey();
                return this.sessionKey != null;
            }
        }
        return false;
    }

    @Override
    public QrzCallsign getCallsignData(String callsign) {
        List<Callsign> alternatives = CallsignUtils.getCallsignVariants(callsign);
        for (Callsign alternative : alternatives) {
            long timeDiff = new Date().getTime() - this.lastTimestamp;
            if (timeDiff < 100L) {
                long pause = 100L - timeDiff;
                try {
                    Thread.sleep(pause);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            QrzCallsign data = this.getCallsignDataInternal(alternative.getCallsign());
            this.lastTimestamp = Instant.now().toEpochMilli();
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public QrzCallsign getCallsignDataInternal(String callsign) {
        if (this.sessionKey != null) {
            String url = String.format("%s/%s/?s=%s;callsign=%s", QRZ_XML_SERVICE_BASE_URL, QRZ_XML_SERVICE_VERSION, this.sessionKey, callsign);
            QrzDatabase database = this.runQuery(url);
            if (database != null) {
                return database.getCallsign();
            }
            logger.warning(String.format("Nothing found on QRZ.COM for: %s", callsign));
        }
        return null;
    }

    private QrzDatabase runQuery(String url) {
        QrzDatabase qrzDatabase;
        block8: {
            Request request = new Request.Builder().url(url).build();
            Response response = this.client.newCall(request).execute();
            try {
                String xmlBody = Objects.requireNonNull(response.body()).string();
                xmlBody = StringUtils.remove((String)xmlBody, (char)'\n');
                ByteArrayInputStream stream = new ByteArrayInputStream(xmlBody.getBytes(StandardCharsets.UTF_8));
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QrzDatabase.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                qrzDatabase = (QrzDatabase)unmarshaller.unmarshal((InputStream)stream);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warning(String.format("QRZ.COM XML query failed: %s, error is: %s", url, e.getMessage()));
                    return null;
                }
            }
            response.close();
        }
        return qrzDatabase;
    }
}

