/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.satellite.ApSatellite;
import uk.m0nom.adifproc.satellite.ApSatellites;
import uk.m0nom.adifproc.satellite.norad.NoradSatellite;
import uk.m0nom.adifproc.satellite.norad.NoradSatelliteOrbitReader;
import uk.m0nom.adifproc.satellite.satellites.SatelliteNameAliases;

@Service
public class ApSatelliteService {
    private final NoradSatelliteOrbitReader noradSatelliteOrbitReader;
    private final SatelliteNameAliases satelliteNameAliases;
    private final ApSatellites satellites;
    private final ZonedDateTime earliestDataAvailable = ZonedDateTime.of(LocalDateTime.of(2022, 2, 23, 0, 0), ZoneId.of("UTC"));

    private void loadCurrentNoradSatelliteTleDataIfRequired() {
        if (this.satellites.noDataFor(ZonedDateTime.now())) {
            this.noradSatelliteOrbitReader.loadCurrentSatelliteTleDataFromCelestrak(this.satellites);
        }
    }

    public ApSatellite getSatellite(String id, ZonedDateTime date) {
        ApSatellite satellite = this.getSatellite(id);
        if (satellite == null || satellite instanceof NoradSatellite) {
            if (ZonedDateTime.now().isEqual(date)) {
                this.loadCurrentNoradSatelliteTleDataIfRequired();
            } else if (this.satellites.noDataFor(date)) {
                this.noradSatelliteOrbitReader.loadTleDataFromArchive(this.satellites, date);
            }
            satellite = this.getSatellite(id);
        }
        return satellite;
    }

    public ApSatellite getSatellite(String id) {
        return this.getSatelliteByNameIdOrAlias(id);
    }

    public ApSatellite getSatelliteByNameIdOrAlias(String id) {
        String satName = this.satelliteNameAliases.getSatelliteName(id.toUpperCase());
        if (satName == null) {
            satName = id.toUpperCase();
        }
        return this.satellites.get(satName);
    }

    public boolean isAKnownSatellite(String id) {
        return this.getSatellite(id) != null;
    }

    public Collection<String> getSatelliteNames() {
        this.loadCurrentNoradSatelliteTleDataIfRequired();
        return this.satellites.getSatelliteNames();
    }

    public int getSatelliteCount() {
        this.loadCurrentNoradSatelliteTleDataIfRequired();
        return this.satellites.getSatelliteCount();
    }

    public ApSatelliteService(NoradSatelliteOrbitReader noradSatelliteOrbitReader, SatelliteNameAliases satelliteNameAliases, ApSatellites satellites) {
        this.noradSatelliteOrbitReader = noradSatelliteOrbitReader;
        this.satelliteNameAliases = satelliteNameAliases;
        this.satellites = satellites;
    }

    public ZonedDateTime getEarliestDataAvailable() {
        return this.earliestDataAvailable;
    }
}

