/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite;

import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.satellite.SatellitePassId;

public class SatellitePass {
    private SatellitePassId id;
    private ZonedDateTime firstContact;
    private ZonedDateTime lastContact;
    private Collection<Qso> contacts;

    public SatellitePass(SatellitePassId id) {
        this.id = id;
        this.contacts = new LinkedList<Qso>();
    }

    public void addContact(Qso qso) {
        ZonedDateTime contact = qso.getRecord().getQsoDate().with(qso.getRecord().getTimeOn());
        this.contacts.add(qso);
        if (this.firstContact == null) {
            this.firstContact = contact;
            this.lastContact = contact;
        } else if (this.firstContact.isAfter(contact)) {
            this.firstContact = contact;
        } else if (this.lastContact.isBefore(contact)) {
            this.lastContact = contact;
        }
    }

    public void spaceOutContacts() {
        Map<LocalTime, Integer> qsoCountPerTime = this.createQsoCountPerTime();
        Iterator<Qso> qsoIterator = this.getContacts().iterator();
        while (qsoIterator.hasNext()) {
            Qso qso = qsoIterator.next();
            LocalTime qsoTime = qso.getRecord().getTimeOn();
            Integer numberOfQsosSharingTime = qsoCountPerTime.get(qsoTime);
            if (numberOfQsosSharingTime <= 1) continue;
            for (int i = 1; i < numberOfQsosSharingTime; ++i) {
                qso = qsoIterator.next();
                LocalTime adjustedTime = qsoTime.plusSeconds(60L / (long)numberOfQsosSharingTime.intValue() * (long)i);
                qso.getRecord().setTimeOn(adjustedTime);
            }
        }
    }

    private Map<LocalTime, Integer> createQsoCountPerTime() {
        HashMap<LocalTime, Integer> qsoCountPerTime = new HashMap<LocalTime, Integer>();
        for (Qso qso : this.contacts) {
            LocalTime time = qso.getRecord().getTimeOn();
            Integer count = (Integer)qsoCountPerTime.get(time);
            count = count != null ? Integer.valueOf(count + 1) : Integer.valueOf(1);
            qsoCountPerTime.put(time, count);
        }
        return qsoCountPerTime;
    }

    public SatellitePassId getId() {
        return this.id;
    }

    public ZonedDateTime getFirstContact() {
        return this.firstContact;
    }

    public ZonedDateTime getLastContact() {
        return this.lastContact;
    }

    public Collection<Qso> getContacts() {
        return this.contacts;
    }

    public void setId(SatellitePassId id) {
        this.id = id;
    }

    public void setFirstContact(ZonedDateTime firstContact) {
        this.firstContact = firstContact;
    }

    public void setLastContact(ZonedDateTime lastContact) {
        this.lastContact = lastContact;
    }

    public void setContacts(Collection<Qso> contacts) {
        this.contacts = contacts;
    }
}

