/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite.norad;

import com.github.amsacode.predict4java.Satellite;
import com.github.amsacode.predict4java.SatelliteFactory;
import com.github.amsacode.predict4java.TLE;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.file.InternalFileService;
import uk.m0nom.adifproc.satellite.ApSatellites;
import uk.m0nom.adifproc.satellite.norad.NoradSatellite;

@Service
public class NoradSatelliteOrbitReader {
    public static final String NORAD_TLE_FILE_LOCATION = "http://www.celestrak.com/NORAD/elements/amateur.txt";
    private static final String NORAD_FOLDER = "norad";
    private static final Logger logger = Logger.getLogger(NoradSatelliteOrbitReader.class.getName());
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final InternalFileService internalFileService;

    public NoradSatelliteOrbitReader(@Qualifier(value="localInternalFileService") InternalFileService internalFileService) {
        this.internalFileService = internalFileService;
    }

    public void loadTleDataFromArchive(ApSatellites satellites, ZonedDateTime date) {
        String filename = String.format("%s-amateur.txt", dateFormatter.format(date));
        String tleDefinitions = this.internalFileService.readFile(NORAD_FOLDER, filename);
        if (tleDefinitions != null) {
            this.parseTleData(satellites, tleDefinitions, date);
        }
    }

    public void loadCurrentSatelliteTleDataFromCelestrak(ApSatellites satellites) {
        logger.info(String.format("Reading NORAD Satellite Definition File: %s", NORAD_TLE_FILE_LOCATION));
        try {
            String tleDefinitions = this.readTleDataFromCelestrak();
            this.parseTleData(satellites, tleDefinitions, ZonedDateTime.now());
        }
        catch (Exception e) {
            logger.severe(String.format("Unable to read TLE definition file: %s", NORAD_TLE_FILE_LOCATION));
        }
    }

    private void parseTleData(ApSatellites satellites, String tleDefinitions, ZonedDateTime onDate) {
        int i;
        String[] tleLines = tleDefinitions.split("\\n");
        for (i = 0; i < tleLines.length / 3; ++i) {
            String[] lines = new String[]{tleLines[i * 3], tleLines[i * 3 + 1], tleLines[i * 3 + 2]};
            TLE tle = new TLE(lines);
            Satellite satellite = SatelliteFactory.createSatellite((TLE)tle);
            NoradSatellite noradSatellite = (NoradSatellite)satellites.get(NoradSatellite.getIdentifier(satellite.getTLE().getName()));
            if (noradSatellite == null) {
                noradSatellite = new NoradSatellite(onDate, satellite);
            } else {
                noradSatellite.addTleData(onDate, satellite);
            }
            satellites.addOrReplace(noradSatellite, onDate);
        }
        logger.info(String.format("Read %d satellite definitions", i));
    }

    private String readTleDataFromCelestrak() throws IOException, URISyntaxException {
        URL u = new URI(NORAD_TLE_FILE_LOCATION).toURL();
        try (InputStream in = u.openStream();){
            String string = new String(in.readAllBytes(), StandardCharsets.US_ASCII);
            return string;
        }
    }
}

