/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite.satellites;

import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.Band;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.satellite.ApSatellite;

public class QO100
implements ApSatellite {
    private static final GlobalCoordinates ESHAIL2_LOCATION = new GlobalCoordinates(0.0, 25.9);
    private static final double ESHAIL2_HEIGHT = 3.6E7;
    private static final String ESHAIL2_NAME = "Es\u2019hail-2";
    private static final String ESHAIL2_DESIGNATOR = "QO-100";
    private static final GlobalCoords3D ESHAIL2_POSITION = new GlobalCoords3D(ESHAIL2_LOCATION, (Double)3.6E7);

    @Override
    public String getIdentifier() {
        if (StringUtils.isNotBlank((CharSequence)this.getDesignator())) {
            return String.format("%s: %s", this.getDesignator(), this.getName());
        }
        return this.getName();
    }

    @Override
    public String getName() {
        return ESHAIL2_NAME;
    }

    @Override
    public String getDesignator() {
        return ESHAIL2_DESIGNATOR;
    }

    @Override
    public GlobalCoords3D getPosition(GlobalCoords3D loc, ZonedDateTime dateTime) {
        return ESHAIL2_POSITION;
    }

    @Override
    public void updateAdifRec(TransformControl control, Adif3Record rec) {
        rec.setBand(Band.BAND_13cm);
        rec.setBandRx(Band.BAND_3cm);
    }

    @Override
    public boolean isGeostationary() {
        return true;
    }
}

