/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.sotacsv;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.AdifHeader;
import org.marsik.ham.adif.enums.Band;
import org.marsik.ham.adif.enums.Mode;
import org.marsik.ham.adif.types.Sota;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.qsofile.QsoFileReader;

@Service
public class SotaCsvFileReader
implements QsoFileReader {
    private static final Logger logger = Logger.getLogger(SotaCsvFileReader.class.getName());
    private final DateFormat internationalDateFormat1 = new SimpleDateFormat("dd/MM/yy");
    private final DateFormat internationalDateFormat2 = new SimpleDateFormat("ddMMyy");
    private final DateFormat internationalTimeFormat1 = new SimpleDateFormat("hh:mm");
    private final DateFormat internationalTimeFormat2 = new SimpleDateFormat("hhmm");
    private final Map<String, String> sotaBandFreqMap = new HashMap<String, String>();

    public SotaCsvFileReader() {
        this.sotaBandFreqMap.put("1.8mhz", "160m");
        this.sotaBandFreqMap.put("3.5mhz", "80m");
        this.sotaBandFreqMap.put("5mhz", "60m");
        this.sotaBandFreqMap.put("7mhz", "40m");
        this.sotaBandFreqMap.put("10mhz", "30m");
        this.sotaBandFreqMap.put("14mhz", "20m");
        this.sotaBandFreqMap.put("18mhz", "17m");
        this.sotaBandFreqMap.put("21mhz", "15m");
        this.sotaBandFreqMap.put("24mhz", "12m");
        this.sotaBandFreqMap.put("28mhz", "10m");
        this.sotaBandFreqMap.put("50mhz", "6m");
        this.sotaBandFreqMap.put("144mhz", "2m");
        this.sotaBandFreqMap.put("432mhz", "70cm");
        this.sotaBandFreqMap.put("1240mhz", "23cm");
    }

    @Override
    public Adif3 read(String filename, String encoding, boolean sort) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(filename));
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream((InputStream)inputStream), StandardCharsets.UTF_8);
        int line = 0;
        CSVParser records = CSVFormat.DEFAULT.parse((Reader)reader);
        Adif3 log = new Adif3();
        AdifHeader header = new AdifHeader();
        header.setProgramId("ADIF Processor SOTA V2 Reader");
        header.setVersion("1.0");
        log.setHeader(header);
        ArrayList<Adif3Record> recs = new ArrayList<Adif3Record>();
        for (CSVRecord record : records) {
            try {
                ++line;
                recs.add(this.readRecord(record));
            }
            catch (IllegalArgumentException | ParseException e) {
                logger.severe(String.format("Error reading line %d: %s", line, e.getMessage()));
            }
        }
        log.setRecords(recs);
        return log;
    }

    private Adif3Record readRecord(CSVRecord record) throws IllegalArgumentException, ParseException {
        Adif3Record rec = new Adif3Record();
        rec.setStationCallsign(this.toUpperAndTrim(record.get(1)));
        rec.setMySotaRef(this.parseSotaRef(record.get(2)));
        rec.setQsoDate(this.parseSotaDate(record.get(3)));
        rec.setTimeOn(this.parseSotaTime(record.get(4)));
        this.parseSotaBand(rec, record.get(5));
        rec.setMode(this.parseSotaMode(record.get(6)));
        rec.setCall(this.toUpperAndTrim(record.get(7)));
        if (record.size() > 8) {
            rec.setSotaRef(this.parseSotaRef(record.get(8)));
        }
        if (record.size() > 9) {
            rec.setComment(this.toUpperAndTrim(record.get(9)));
        }
        return rec;
    }

    private Sota parseSotaRef(String ref) {
        if (ref != null) {
            return Sota.valueOf(ref.trim().toUpperCase());
        }
        return null;
    }

    private Mode parseSotaMode(String sotaMode) {
        if (sotaMode != null) {
            return Mode.valueOf(sotaMode.trim().toUpperCase());
        }
        return null;
    }

    private void parseSotaBand(Adif3Record rec, String sotaBand) {
        if (sotaBand != null) {
            String bandOrFreq = sotaBand.toLowerCase();
            if (bandOrFreq.endsWith("m")) {
                this.setBandFromSotaBand(rec, bandOrFreq);
            } else if (bandOrFreq.endsWith("mhz")) {
                this.setBandFromSotaFreq(rec, bandOrFreq);
            }
        }
    }

    private void setBandFromSotaBand(Adif3Record rec, String bandOrFreq) {
        this.parseFrequency(rec, bandOrFreq);
        rec.setBand(Band.valueOf(bandOrFreq));
    }

    private void setBandFromSotaFreq(Adif3Record rec, String bandOrFreq) {
        String possibleBand = this.sotaBandFreqMap.get(bandOrFreq);
        if (possibleBand != null) {
            try {
                Band band = Band.valueOf(String.format("BAND_%s", possibleBand));
                rec.setBand(band);
            }
            catch (IllegalArgumentException e) {
                rec.setBand(null);
            }
        }
        if (rec.getBand() == null) {
            String freqValue = StringUtils.removeEnd((String)bandOrFreq, (String)"mhz");
            this.parseFrequency(rec, freqValue);
        }
    }

    private void parseFrequency(Adif3Record rec, String freqValue) {
        try {
            double freq = Double.parseDouble(freqValue);
            rec.setFreq(freq);
            for (Band toCheck : Band.values()) {
                if (!(freq >= toCheck.getLowerFrequency()) || !(freq <= toCheck.getUpperFrequency())) continue;
                rec.setBand(toCheck);
            }
        }
        catch (NumberFormatException nfe) {
            logger.severe(String.format("Unable to parse frequency value of: %s", freqValue));
        }
    }

    private LocalTime parseSotaTime(String sotaTime) throws ParseException {
        LocalTime time;
        try {
            time = new Time(this.internationalTimeFormat1.parse(sotaTime).getTime()).toLocalTime();
        }
        catch (ParseException e) {
            time = new Time(this.internationalTimeFormat2.parse(sotaTime).getTime()).toLocalTime();
        }
        return time;
    }

    private String toUpperAndTrim(String value) {
        String rtn = null;
        if (value != null) {
            rtn = value.toUpperCase().trim();
        }
        return rtn;
    }

    private ZonedDateTime parseSotaDate(String sotaDate) throws ParseException {
        ZonedDateTime date;
        try {
            date = this.parseDateStringUsingFormat(sotaDate, this.internationalDateFormat1);
        }
        catch (ParseException e) {
            date = this.parseDateStringUsingFormat(sotaDate, this.internationalDateFormat2);
        }
        return date;
    }

    private ZonedDateTime parseDateStringUsingFormat(String dateString, DateFormat df) throws ParseException {
        LocalDate localDate = new Date(df.parse(dateString).getTime()).toLocalDate();
        return ZonedDateTime.of(localDate, LocalTime.of(0, 0), ZoneId.of("UTC"));
    }
}

