/*
 * Decompiled with CFR 0.152.
 */
package uk.megaslice.delta;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.megaslice.delta.DuplicateKeyException;
import uk.megaslice.delta.Equivalence;
import uk.megaslice.delta.Essence;
import uk.megaslice.delta.NaturalKey;
import uk.megaslice.delta.Operation;

public final class Delta<T, K> {
    private final Map<K, Operation<T>> operations;
    private static final Delta<Object, Object> EMPTY = new Delta(Collections.emptyMap());

    private Delta(Map<K, Operation<T>> operations) {
        this.operations = Collections.unmodifiableMap(operations);
    }

    public Map<K, Operation<T>> operations() {
        return this.operations;
    }

    public Collection<Operation<T>> inserts() {
        return this.operations.values().stream().filter(o -> o.type() == Operation.Type.INSERT).collect(Collectors.toList());
    }

    public Collection<T> insertedItems() {
        return this.operations.values().stream().filter(o -> o.type() == Operation.Type.INSERT).map(Operation::newItem).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    public Collection<Operation<T>> updates() {
        return this.operations.values().stream().filter(o -> o.type() == Operation.Type.UPDATE).collect(Collectors.toList());
    }

    public Collection<T> updatedItems() {
        return this.operations.values().stream().filter(o -> o.type() == Operation.Type.UPDATE).map(Operation::newItem).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    public Collection<Operation<T>> deletes() {
        return this.operations.values().stream().filter(o -> o.type() == Operation.Type.DELETE).collect(Collectors.toList());
    }

    public Collection<T> deletedItems() {
        return this.operations.values().stream().filter(o -> o.type() == Operation.Type.DELETE).map(Operation::oldItem).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    public Optional<Operation<T>> get(K key) {
        Objects.requireNonNull(key, "key must not be null");
        return Optional.ofNullable(this.operations.get(key));
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public Collection<T> apply(Iterable<T> items, NaturalKey<T, K> naturalKey) {
        Objects.requireNonNull(items, "items must not be null");
        Objects.requireNonNull(naturalKey, "naturalKey must not be null");
        HashMap<K, Operation<T>> remainingOps = new HashMap<K, Operation<T>>(this.operations);
        HashMap itemsByKey = new HashMap();
        for (T item : items) {
            K key = Delta.keyOf(item, naturalKey);
            if (itemsByKey.containsKey(key)) {
                throw new DuplicateKeyException("Duplicate key in items: " + key);
            }
            this.applyUpdateOrUnchanged(remainingOps, itemsByKey, item, key);
        }
        this.applyInsertsAndDeletes(remainingOps, itemsByKey);
        return Collections.unmodifiableCollection(itemsByKey.values());
    }

    public Map<K, T> apply(Map<K, T> items) {
        Objects.requireNonNull(items, "items must not be null");
        HashMap<K, Operation<T>> remainingOps = new HashMap<K, Operation<T>>(this.operations);
        HashMap itemsByKey = new HashMap();
        for (Map.Entry<K, T> entry : items.entrySet()) {
            K key = entry.getKey();
            T item = entry.getValue();
            Delta.requireNonNullKeyAndItem(key, item, "");
            this.applyUpdateOrUnchanged(remainingOps, itemsByKey, item, key);
        }
        this.applyInsertsAndDeletes(remainingOps, itemsByKey);
        return Collections.unmodifiableMap(itemsByKey);
    }

    private void applyUpdateOrUnchanged(Map<K, Operation<T>> remainingOps, Map<K, T> itemsByKey, T item, K key) {
        Operation<T> op = this.operations.get(key);
        if (op instanceof Operation.Update) {
            Object updatedItem = ((Operation.Update)op).after;
            itemsByKey.put(key, updatedItem);
            remainingOps.remove(key);
        } else {
            itemsByKey.put(key, item);
        }
    }

    private void applyInsertsAndDeletes(Map<K, Operation<T>> remainingOps, Map<K, T> itemsByKey) {
        for (Map.Entry<K, Operation<T>> entry : remainingOps.entrySet()) {
            Operation<T> op = entry.getValue();
            if (op instanceof Operation.Insert) {
                Object itemToInsert = ((Operation.Insert)op).item;
                if (itemsByKey.put(entry.getKey(), itemToInsert) == null) continue;
                throw new DuplicateKeyException("Duplicate key in operations: " + entry.getKey());
            }
            itemsByKey.remove(entry.getKey());
        }
    }

    public Delta<T, K> combine(Delta<T, K> other) {
        return this.combine(other, Equivalence.defaultEquivalence());
    }

    public <U> Delta<T, K> combine(Delta<T, K> other, Essence<T, U> essence) {
        Objects.requireNonNull(essence, "essence must not be null");
        return this.combine(other, essence.asEquivalence());
    }

    public Delta<T, K> combine(Delta<T, K> other, Equivalence<T> equivalence) {
        Objects.requireNonNull(other, "other must not be null");
        Objects.requireNonNull(equivalence, "equivalence must not be null");
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        HashMap<K, Operation<T>> combined = new HashMap<K, Operation<T>>(this.operations);
        for (Map.Entry<K, Operation<T>> entry : other.operations.entrySet()) {
            K key = entry.getKey();
            Operation left = (Operation)combined.get(key);
            Operation<T> right = entry.getValue();
            if (left == null) {
                combined.put(key, right);
                continue;
            }
            Optional<Operation<T>> combinedOp = left.combine(right, equivalence);
            if (combinedOp.isPresent()) {
                combined.put(key, combinedOp.get());
                continue;
            }
            combined.remove(key);
        }
        return new Delta<T, K>(combined);
    }

    public static <T, K> Delta<T, K> empty() {
        Delta<Object, Object> emptyDelta = EMPTY;
        return emptyDelta;
    }

    public static <T, K> Delta<T, K> diff(Iterable<T> before, Iterable<T> after, NaturalKey<T, K> naturalKey) {
        return Delta.diff(before, after, naturalKey, Equivalence.defaultEquivalence());
    }

    public static <T, U, K> Delta<T, K> diff(Iterable<T> before, Iterable<T> after, NaturalKey<T, K> naturalKey, Essence<T, U> essence) {
        return Delta.diff(before, after, naturalKey, essence.asEquivalence());
    }

    public static <T, K> Delta<T, K> diff(Iterable<T> before, Iterable<T> after, NaturalKey<T, K> naturalKey, Equivalence<T> equivalence) {
        Objects.requireNonNull(before, "before must not be null");
        Objects.requireNonNull(after, "after must not be null");
        Objects.requireNonNull(naturalKey, "naturalKey must not be null");
        Objects.requireNonNull(equivalence, "equivalence must not be null");
        if (before == after) {
            return Delta.empty();
        }
        HashMap operations = new HashMap();
        for (T beforeItem : before) {
            K key = Delta.keyOf(beforeItem, naturalKey);
            Operation<T> existing = operations.put(key, Operation.delete(beforeItem));
            if (existing == null) continue;
            throw new DuplicateKeyException("Duplicate key in 'before' items: " + key);
        }
        HashSet<K> removed = new HashSet<K>();
        for (T afterItem : after) {
            K key = Delta.keyOf(afterItem, naturalKey);
            if (removed.contains(key)) {
                throw new DuplicateKeyException("Duplicate key in 'after' items: " + key);
            }
            Operation existing = (Operation)operations.get(key);
            if (existing == null) {
                operations.put(key, Operation.insert(afterItem));
                continue;
            }
            if (existing instanceof Operation.Delete) {
                Object beforeItem = ((Operation.Delete)existing).item;
                if (equivalence.isEquivalent(beforeItem, afterItem)) {
                    operations.remove(key);
                    removed.add(key);
                    continue;
                }
                operations.put(key, Operation.update(beforeItem, afterItem));
                continue;
            }
            throw new DuplicateKeyException("Duplicate key in 'after' items: " + key);
        }
        return new Delta(operations);
    }

    public static <T, K> Delta<T, K> diff(Map<K, T> before, Map<K, T> after) {
        return Delta.diff(before, after, Equivalence.defaultEquivalence());
    }

    public static <T, U, K> Delta<T, K> diff(Map<K, T> before, Map<K, T> after, Essence<T, U> essence) {
        Objects.requireNonNull(essence, "essence must not be null");
        return Delta.diff(before, after, essence.asEquivalence());
    }

    public static <T, K> Delta<T, K> diff(Map<K, T> before, Map<K, T> after, Equivalence<T> equivalence) {
        K key;
        Objects.requireNonNull(before, "before must not be null");
        Objects.requireNonNull(after, "after must not be null");
        Objects.requireNonNull(equivalence, "equivalence must not be null");
        if (before == after) {
            return Delta.empty();
        }
        HashMap<K, Operation<T>> operations = new HashMap<K, Operation<T>>();
        for (Map.Entry<K, T> entry : before.entrySet()) {
            key = entry.getKey();
            T beforeItem = entry.getValue();
            Delta.requireNonNullKeyAndItem(key, beforeItem, "before ");
            operations.put(key, Operation.delete(beforeItem));
        }
        for (Map.Entry<K, T> entry : after.entrySet()) {
            key = entry.getKey();
            T afterItem = entry.getValue();
            Delta.requireNonNullKeyAndItem(key, afterItem, "after ");
            T beforeItem = before.get(key);
            if (beforeItem == null) {
                operations.put(key, Operation.insert(afterItem));
                continue;
            }
            if (equivalence.isEquivalent(beforeItem, afterItem)) {
                operations.remove(key);
                continue;
            }
            operations.put(key, Operation.update(beforeItem, afterItem));
        }
        return new Delta(operations);
    }

    private static <T, K> K keyOf(T item, NaturalKey<T, K> naturalKey) {
        Objects.requireNonNull(item, "item must not be null");
        K key = naturalKey.getNaturalKey(item);
        if (key == null) {
            throw new NullPointerException("null key for item: " + item);
        }
        return key;
    }

    private static <T, K> void requireNonNullKeyAndItem(K key, T item, String label) {
        if (key == null) {
            throw new NullPointerException(label + "key must not be null");
        }
        if (item == null) {
            throw new NullPointerException(label + "item must not be null");
        }
    }

    public String toString() {
        return "Delta(operations=" + this.operations + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delta)) {
            return false;
        }
        Delta other = (Delta)o;
        Map<K, Operation<T>> this$operations = this.operations;
        Map<K, Operation<T>> other$operations = other.operations;
        return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<K, Operation<T>> $operations = this.operations;
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        return result;
    }
}

