/*
 * Decompiled with CFR 0.152.
 */
package uk.megaslice.delta;

import java.util.Objects;
import java.util.Optional;
import uk.megaslice.delta.Equivalence;
import uk.megaslice.delta.InvalidCombination;

public abstract class Operation<T> {
    private Operation() {
    }

    public abstract Type type();

    public Optional<T> oldItem() {
        return Optional.empty();
    }

    public Optional<T> newItem() {
        return Optional.empty();
    }

    public Optional<Operation<T>> combine(Operation<T> other) {
        return this.combine(other, Equivalence.defaultEquivalence());
    }

    public abstract Optional<Operation<T>> combine(Operation<T> var1, Equivalence<T> var2);

    public static <T> Operation<T> insert(T item) {
        Objects.requireNonNull(item, "item must not be null");
        return new Insert(item);
    }

    public static <T> Operation<T> update(T before, T after) {
        Objects.requireNonNull(before, "before must not be null");
        Objects.requireNonNull(after, "after must not be null");
        return new Update(before, after);
    }

    public static <T> Operation<T> delete(T item) {
        Objects.requireNonNull(item, "item must not be null");
        return new Delete(item);
    }

    static class Delete<T>
    extends Operation<T> {
        final T item;

        private Delete(T item) {
            this.item = item;
        }

        @Override
        public Type type() {
            return Type.DELETE;
        }

        @Override
        public Optional<T> oldItem() {
            return Optional.of(this.item);
        }

        @Override
        public Optional<Operation<T>> combine(Operation<T> other, Equivalence<T> equivalence) {
            Objects.requireNonNull(other, "other must not be null");
            Objects.requireNonNull(equivalence, "equivalence must not be null");
            if (other instanceof Insert) {
                Object otherItem = ((Insert)other).item;
                return equivalence.isEquivalent(this.item, otherItem) ? Optional.empty() : Optional.of(new Update(this.item, otherItem));
            }
            if (other instanceof Update) {
                throw new InvalidCombination(Type.DELETE, Type.UPDATE);
            }
            if (other instanceof Delete) {
                throw new InvalidCombination(Type.DELETE, Type.DELETE);
            }
            throw new IllegalStateException("Unsupported operation type: " + other.getClass());
        }

        public String toString() {
            return "Operation.Delete(item=" + this.item + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Delete)) {
                return false;
            }
            Delete other = (Delete)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$item = this.item;
            T other$item = other.item;
            return !(this$item == null ? other$item != null : !this$item.equals(other$item));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Delete;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $item = this.item;
            result = result * 59 + ($item == null ? 43 : $item.hashCode());
            return result;
        }
    }

    static class Update<T>
    extends Operation<T> {
        final T before;
        final T after;

        private Update(T before, T after) {
            this.before = before;
            this.after = after;
        }

        @Override
        public Type type() {
            return Type.UPDATE;
        }

        @Override
        public Optional<T> oldItem() {
            return Optional.of(this.before);
        }

        @Override
        public Optional<T> newItem() {
            return Optional.of(this.after);
        }

        @Override
        public Optional<Operation<T>> combine(Operation<T> other, Equivalence<T> equivalence) {
            Objects.requireNonNull(other, "other must not be null");
            Objects.requireNonNull(equivalence, "equivalence must not be null");
            if (other instanceof Insert) {
                throw new InvalidCombination(Type.UPDATE, Type.INSERT);
            }
            if (other instanceof Update) {
                T otherAfter = ((Update)other).after;
                return equivalence.isEquivalent(this.before, otherAfter) ? Optional.empty() : Optional.of(new Update<T>(this.before, otherAfter));
            }
            if (other instanceof Delete) {
                return Optional.of(other);
            }
            throw new IllegalStateException("Unsupported operation type: " + other.getClass());
        }

        public String toString() {
            return "Operation.Update(before=" + this.before + ", after=" + this.after + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Update)) {
                return false;
            }
            Update other = (Update)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$before = this.before;
            T other$before = other.before;
            if (this$before == null ? other$before != null : !this$before.equals(other$before)) {
                return false;
            }
            T this$after = this.after;
            T other$after = other.after;
            return !(this$after == null ? other$after != null : !this$after.equals(other$after));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Update;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $before = this.before;
            result = result * 59 + ($before == null ? 43 : $before.hashCode());
            T $after = this.after;
            result = result * 59 + ($after == null ? 43 : $after.hashCode());
            return result;
        }
    }

    static class Insert<T>
    extends Operation<T> {
        final T item;

        private Insert(T item) {
            this.item = item;
        }

        @Override
        public Type type() {
            return Type.INSERT;
        }

        @Override
        public Optional<T> newItem() {
            return Optional.of(this.item);
        }

        @Override
        public Optional<Operation<T>> combine(Operation<T> other, Equivalence<T> equivalence) {
            Objects.requireNonNull(other, "other must not be null");
            Objects.requireNonNull(equivalence, "equivalence must not be null");
            if (other instanceof Insert) {
                throw new InvalidCombination(Type.INSERT, Type.INSERT);
            }
            if (other instanceof Update) {
                return Optional.of(new Insert(((Update)other).after));
            }
            if (other instanceof Delete) {
                return Optional.empty();
            }
            throw new IllegalStateException("Unsupported operation type: " + other.getClass());
        }

        public String toString() {
            return "Operation.Insert(item=" + this.item + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Insert)) {
                return false;
            }
            Insert other = (Insert)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$item = this.item;
            T other$item = other.item;
            return !(this$item == null ? other$item != null : !this$item.equals(other$item));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Insert;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $item = this.item;
            result = result * 59 + ($item == null ? 43 : $item.hashCode());
            return result;
        }
    }

    public static enum Type {
        INSERT,
        UPDATE,
        DELETE;

    }
}

