/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.lang;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import uk.org.lidalia.lang.Exceptions;

public class LazyValue<T>
implements Callable<T> {
    private final FutureTask<T> supplier;

    public LazyValue(Callable<T> supplier) {
        this.supplier = new FutureTask<T>(supplier);
    }

    @Override
    public T call() {
        this.supplier.run();
        try {
            return (T)Uninterruptibles.getUninterruptibly(this.supplier);
        }
        catch (ExecutionException e) {
            return (T)Exceptions.throwUnchecked(e.getCause(), null);
        }
    }

    public String toString() {
        if (this.supplier.isDone()) {
            return this.call().toString();
        }
        return "not yet evaluated";
    }
}

