/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.slf4jtest;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import uk.org.lidalia.lang.LazyValue;
import uk.org.lidalia.lang.ThreadLocal;
import uk.org.lidalia.slf4jext.Level;
import uk.org.lidalia.slf4jtest.LoggingEvent;
import uk.org.lidalia.slf4jtest.OverridableProperties;
import uk.org.lidalia.slf4jtest.TestLogger;

public final class TestLoggerFactory
implements ILoggerFactory {
    private static final LazyValue<TestLoggerFactory> INSTANCE = new LazyValue((Callable)new TestLoggerFactoryMaker());
    private final ConcurrentMap<String, TestLogger> loggers;
    private final List<LoggingEvent> allLoggingEvents;
    private final ThreadLocal<List<LoggingEvent>> loggingEvents;
    private volatile Level printLevel;

    public static TestLoggerFactory getInstance() {
        return (TestLoggerFactory)INSTANCE.call();
    }

    public static TestLogger getTestLogger(Class<?> aClass) {
        return TestLoggerFactory.getInstance().getLogger(aClass);
    }

    public static TestLogger getTestLogger(String name) {
        return TestLoggerFactory.getInstance().getLogger(name);
    }

    public static Map<String, TestLogger> getAllTestLoggers() {
        return TestLoggerFactory.getInstance().getAllLoggers();
    }

    public static void clear() {
        TestLoggerFactory.getInstance().clearLoggers();
    }

    public static void clearAll() {
        TestLoggerFactory.getInstance().clearAllLoggers();
    }

    static void reset() {
        TestLoggerFactory.getInstance().doReset();
    }

    public static List<LoggingEvent> getLoggingEvents() {
        return TestLoggerFactory.getInstance().getLoggingEventsFromLoggers();
    }

    public static List<LoggingEvent> getAllLoggingEvents() {
        return TestLoggerFactory.getInstance().getAllLoggingEventsFromLoggers();
    }

    /*
     * Exception decompiling
     */
    private TestLoggerFactory(Level printLevel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Level getPrintLevel() {
        return this.printLevel;
    }

    public ImmutableMap<String, TestLogger> getAllLoggers() {
        return ImmutableMap.copyOf(this.loggers);
    }

    public TestLogger getLogger(Class<?> aClass) {
        return this.getLogger(aClass.getName());
    }

    public TestLogger getLogger(String name) {
        TestLogger newLogger = new TestLogger(name, this);
        return (TestLogger)Optional.fromNullable((Object)this.loggers.putIfAbsent(name, newLogger)).or((Object)newLogger);
    }

    public void clearLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clear();
        }
        ((List)this.loggingEvents.get()).clear();
    }

    public void clearAllLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clearAll();
        }
        this.loggingEvents.reset();
        this.allLoggingEvents.clear();
    }

    void doReset() {
        this.clearAllLoggers();
        this.loggers.clear();
    }

    public ImmutableList<LoggingEvent> getLoggingEventsFromLoggers() {
        return ImmutableList.copyOf((Collection)((Collection)this.loggingEvents.get()));
    }

    public List<LoggingEvent> getAllLoggingEventsFromLoggers() {
        return this.allLoggingEvents;
    }

    void addLoggingEvent(LoggingEvent event) {
        ((List)this.loggingEvents.get()).add(event);
        this.allLoggingEvents.add(event);
    }

    public void setPrintLevel(Level printLevel) {
        this.printLevel = (Level)Preconditions.checkNotNull((Object)printLevel);
    }

    private static class TestLoggerFactoryMaker
    implements Callable<TestLoggerFactory> {
        private TestLoggerFactoryMaker() {
        }

        @Override
        public TestLoggerFactory call() throws IOException {
            try {
                String level = new OverridableProperties("slf4jtest").getProperty("print.level", "OFF");
                Level printLevel = Level.valueOf((String)level);
                return new TestLoggerFactory(printLevel);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Invalid level name in property print.level of file slf4jtest.properties or System property slf4jtest.print.level", e);
            }
        }
    }
}

