/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.slf4jtest;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.ILoggerFactory;
import uk.org.lidalia.lang.LazyValue;
import uk.org.lidalia.lang.ThreadLocal;
import uk.org.lidalia.slf4jext.Level;
import uk.org.lidalia.slf4jtest.LoggingEvent;
import uk.org.lidalia.slf4jtest.OverridableProperties;
import uk.org.lidalia.slf4jtest.Suppliers;
import uk.org.lidalia.slf4jtest.TestLogger;

public final class TestLoggerFactory
implements ILoggerFactory {
    private static final LazyValue<TestLoggerFactory> INSTANCE = new LazyValue((Callable)new TestLoggerFactoryMaker());
    private final ConcurrentMap<String, TestLogger> loggers = new ConcurrentHashMap<String, TestLogger>();
    private final List<LoggingEvent> allLoggingEvents = new CopyOnWriteArrayList<LoggingEvent>();
    private final ThreadLocal<List<LoggingEvent>> loggingEvents = new ThreadLocal(Suppliers.makeEmptyMutableList());
    private volatile Level printLevel;

    public static TestLoggerFactory getInstance() {
        return (TestLoggerFactory)INSTANCE.call();
    }

    public static TestLogger getTestLogger(Class<?> aClass) {
        return TestLoggerFactory.getInstance().getLogger(aClass);
    }

    public static TestLogger getTestLogger(String name) {
        return TestLoggerFactory.getInstance().getLogger(name);
    }

    public static Map<String, TestLogger> getAllTestLoggers() {
        return TestLoggerFactory.getInstance().getAllLoggers();
    }

    public static void clear() {
        TestLoggerFactory.getInstance().clearLoggers();
    }

    public static void clearAll() {
        TestLoggerFactory.getInstance().clearAllLoggers();
    }

    static void reset() {
        TestLoggerFactory.getInstance().doReset();
    }

    public static List<LoggingEvent> getLoggingEvents() {
        return TestLoggerFactory.getInstance().getLoggingEventsFromLoggers();
    }

    public static List<LoggingEvent> getAllLoggingEvents() {
        return TestLoggerFactory.getInstance().getAllLoggingEventsFromLoggers();
    }

    private TestLoggerFactory(Level printLevel) {
        this.printLevel = (Level)Preconditions.checkNotNull((Object)printLevel);
    }

    public Level getPrintLevel() {
        return this.printLevel;
    }

    public ImmutableMap<String, TestLogger> getAllLoggers() {
        return ImmutableMap.copyOf(this.loggers);
    }

    public TestLogger getLogger(Class<?> aClass) {
        return this.getLogger(aClass.getName());
    }

    public TestLogger getLogger(String name) {
        TestLogger newLogger = new TestLogger(name, this);
        return (TestLogger)Optional.fromNullable((Object)this.loggers.putIfAbsent(name, newLogger)).or((Object)newLogger);
    }

    public void clearLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clear();
        }
        ((List)this.loggingEvents.get()).clear();
    }

    public void clearAllLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clearAll();
        }
        this.loggingEvents.reset();
        this.allLoggingEvents.clear();
    }

    void doReset() {
        this.clearAllLoggers();
        this.loggers.clear();
    }

    public ImmutableList<LoggingEvent> getLoggingEventsFromLoggers() {
        return ImmutableList.copyOf((Collection)((Collection)this.loggingEvents.get()));
    }

    public List<LoggingEvent> getAllLoggingEventsFromLoggers() {
        return this.allLoggingEvents;
    }

    void addLoggingEvent(LoggingEvent event) {
        ((List)this.loggingEvents.get()).add(event);
        this.allLoggingEvents.add(event);
    }

    public void setPrintLevel(Level printLevel) {
        this.printLevel = (Level)Preconditions.checkNotNull((Object)printLevel);
    }

    private static class TestLoggerFactoryMaker
    implements Callable<TestLoggerFactory> {
        private TestLoggerFactoryMaker() {
        }

        @Override
        public TestLoggerFactory call() throws IOException {
            try {
                String level = new OverridableProperties("slf4jtest").getProperty("print.level", "OFF");
                Level printLevel = Level.valueOf((String)level);
                return new TestLoggerFactory(printLevel);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Invalid level name in property print.level of file slf4jtest.properties or System property slf4jtest.print.level", e);
            }
        }
    }
}

