/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.slf4jtest;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import uk.org.lidalia.lang.ThreadLocal;
import uk.org.lidalia.slf4jext.Level;
import uk.org.lidalia.slf4jtest.LoggingEvent;
import uk.org.lidalia.slf4jtest.Suppliers;
import uk.org.lidalia.slf4jtest.TestLoggerFactory;

public class TestLogger
implements Logger {
    private final String name;
    private final TestLoggerFactory testLoggerFactory;
    private final ThreadLocal<List<LoggingEvent>> loggingEvents = new ThreadLocal(Suppliers.makeEmptyMutableList());
    private final List<LoggingEvent> allLoggingEvents = new CopyOnWriteArrayList<LoggingEvent>();
    private volatile ThreadLocal<ImmutableSet<Level>> enabledLevels = new ThreadLocal((Object)Level.enablableValueSet());

    TestLogger(String name, TestLoggerFactory testLoggerFactory) {
        this.name = name;
        this.testLoggerFactory = testLoggerFactory;
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        ((List)this.loggingEvents.get()).clear();
        this.enabledLevels.remove();
    }

    public void clearAll() {
        this.allLoggingEvents.clear();
        this.loggingEvents.reset();
        this.enabledLevels.reset();
    }

    public ImmutableList<LoggingEvent> getLoggingEvents() {
        return ImmutableList.copyOf((Collection)((Collection)this.loggingEvents.get()));
    }

    public ImmutableList<LoggingEvent> getAllLoggingEvents() {
        return ImmutableList.copyOf(this.allLoggingEvents);
    }

    public boolean isTraceEnabled() {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.TRACE);
    }

    public void trace(String message) {
        this.log(Level.TRACE, message, new Object[0]);
    }

    public void trace(String format, Object arg) {
        this.log(Level.TRACE, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object ... args) {
        this.log(Level.TRACE, format, args);
    }

    public void trace(String msg, Throwable throwable) {
        this.log(Level.TRACE, msg, throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.TRACE);
    }

    public void trace(Marker marker, String msg) {
        this.log(Level.TRACE, marker, msg, new Object[0]);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.log(Level.TRACE, marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... args) {
        this.log(Level.TRACE, marker, format, args);
    }

    public void trace(Marker marker, String msg, Throwable throwable) {
        this.log(Level.TRACE, marker, msg, throwable);
    }

    public boolean isDebugEnabled() {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.DEBUG);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.log(Level.DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public void debug(String msg, Throwable throwable) {
        this.log(Level.DEBUG, msg, throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.DEBUG);
    }

    public void debug(Marker marker, String msg) {
        this.log(Level.DEBUG, marker, msg, new Object[0]);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.log(Level.DEBUG, marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... args) {
        this.log(Level.DEBUG, marker, format, args);
    }

    public void debug(Marker marker, String msg, Throwable throwable) {
        this.log(Level.DEBUG, marker, msg, throwable);
    }

    public boolean isInfoEnabled() {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.INFO);
    }

    public void info(String message) {
        this.log(Level.INFO, message, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.log(Level.INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public void info(String msg, Throwable throwable) {
        this.log(Level.INFO, msg, throwable);
    }

    public boolean isInfoEnabled(Marker marker) {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.INFO);
    }

    public void info(Marker marker, String msg) {
        this.log(Level.INFO, marker, msg, new Object[0]);
    }

    public void info(Marker marker, String format, Object arg) {
        this.log(Level.INFO, marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.INFO, marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... args) {
        this.log(Level.INFO, marker, format, args);
    }

    public void info(Marker marker, String msg, Throwable throwable) {
        this.log(Level.INFO, marker, msg, throwable);
    }

    public boolean isWarnEnabled() {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.WARN);
    }

    public void warn(String message) {
        this.log(Level.WARN, message, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.log(Level.WARN, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, format, arg1, arg2);
    }

    public void warn(String format, Object ... args) {
        this.log(Level.WARN, format, args);
    }

    public void warn(String msg, Throwable throwable) {
        this.log(Level.WARN, msg, throwable);
    }

    public boolean isWarnEnabled(Marker marker) {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.WARN);
    }

    public void warn(Marker marker, String msg) {
        this.log(Level.WARN, marker, msg, new Object[0]);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.log(Level.WARN, marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.WARN, marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... args) {
        this.log(Level.WARN, marker, format, args);
    }

    public void warn(Marker marker, String msg, Throwable throwable) {
        this.log(Level.WARN, marker, msg, throwable);
    }

    public boolean isErrorEnabled() {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.ERROR);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, new Object[0]);
    }

    public void error(String format, Object arg) {
        this.log(Level.ERROR, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    public void error(String msg, Throwable throwable) {
        this.log(Level.ERROR, msg, throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return ((ImmutableSet)this.enabledLevels.get()).contains((Object)Level.ERROR);
    }

    public void error(Marker marker, String msg) {
        this.log(Level.ERROR, marker, msg, new Object[0]);
    }

    public void error(Marker marker, String format, Object arg) {
        this.log(Level.ERROR, marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... args) {
        this.log(Level.ERROR, marker, format, args);
    }

    public void error(Marker marker, String msg, Throwable throwable) {
        this.log(Level.ERROR, marker, msg, throwable);
    }

    private void log(Level level, String format, Object ... args) {
        this.log(level, format, (Optional<Marker>)Optional.absent(), args);
    }

    private void log(Level level, String msg, Throwable throwable) {
        this.addLoggingEvent(level, (Optional<Marker>)Optional.absent(), (Optional<Throwable>)Optional.fromNullable((Object)throwable), msg, new Object[0]);
    }

    private void log(Level level, Marker marker, String format, Object ... args) {
        this.log(level, format, (Optional<Marker>)Optional.fromNullable((Object)marker), args);
    }

    private void log(Level level, Marker marker, String msg, Throwable throwable) {
        this.addLoggingEvent(level, (Optional<Marker>)Optional.fromNullable((Object)marker), (Optional<Throwable>)Optional.fromNullable((Object)throwable), msg, new Object[0]);
    }

    private void log(Level level, String format, Optional<Marker> marker, Object[] args) {
        FormattingTuple formattedArgs = MessageFormatter.arrayFormat((String)format, (Object[])args);
        this.addLoggingEvent(level, marker, (Optional<Throwable>)Optional.fromNullable((Object)formattedArgs.getThrowable()), format, formattedArgs.getArgArray());
    }

    private void addLoggingEvent(Level level, Optional<Marker> marker, Optional<Throwable> throwable, String format, Object ... args) {
        if (((ImmutableSet)this.enabledLevels.get()).contains((Object)level)) {
            LoggingEvent event = new LoggingEvent((Optional<TestLogger>)Optional.of((Object)this), level, this.mdc(), marker, throwable, format, args);
            this.allLoggingEvents.add(event);
            ((List)this.loggingEvents.get()).add(event);
            this.testLoggerFactory.addLoggingEvent(event);
            this.optionallyPrint(event);
        }
    }

    private Map<String, String> mdc() {
        return (Map)Optional.fromNullable((Object)MDC.getCopyOfContextMap()).or(Collections.emptyMap());
    }

    private void optionallyPrint(LoggingEvent event) {
        if (this.testLoggerFactory.getPrintLevel().compareTo((Enum)event.getLevel()) <= 0) {
            event.print();
        }
    }

    public ImmutableSet<Level> getEnabledLevels() {
        return (ImmutableSet)this.enabledLevels.get();
    }

    public void setEnabledLevels(ImmutableSet<Level> enabledLevels) {
        this.enabledLevels.set(enabledLevels);
    }

    public void setEnabledLevels(Level ... enabledLevels) {
        this.setEnabledLevels((ImmutableSet<Level>)Sets.immutableEnumSet(Arrays.asList(enabledLevels)));
    }

    public void setEnabledLevelsForAllThreads(ImmutableSet<Level> enabledLevelsForAllThreads) {
        this.enabledLevels = new ThreadLocal(enabledLevelsForAllThreads);
    }

    public void setEnabledLevelsForAllThreads(Level ... enabledLevelsForAllThreads) {
        this.setEnabledLevelsForAllThreads((ImmutableSet<Level>)ImmutableSet.copyOf((Object[])enabledLevelsForAllThreads));
    }
}

