/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.lightweightconfig;

import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import uk.org.webcompere.lightweightconfig.ConfigLoaderException;
import uk.org.webcompere.lightweightconfig.properties.PropertiesLoader;
import uk.org.webcompere.lightweightconfig.provider.FileProvider;
import uk.org.webcompere.lightweightconfig.provider.ResourceProvider;

public class ConfigLoader {
    private UnaryOperator<String> resourceProvider = ResourceProvider::readAndProcessResource;
    private Map<String, Function<String, ?>> tags = new ConcurrentHashMap();

    public static <T> T loadYmlConfigFromResource(String resourceName, Class<T> type) {
        return new ConfigLoader().loadAs(resourceName, type);
    }

    public static Map<String, Object> loadYmlConfigFromResource(String resourceName) {
        return new ConfigLoader().load(resourceName);
    }

    public static <T> T loadYmlConfig(Path file, Class<T> type) {
        return new ConfigLoader().loadAs(file, type);
    }

    public static Map<String, Object> loadYmlConfig(Path file) {
        return new ConfigLoader().load(file);
    }

    public static Properties loadPropertiesFromResource(String resourceName) {
        return PropertiesLoader.load(resourceName);
    }

    public static Properties loadProperties(Path file) {
        return PropertiesLoader.load(file);
    }

    public <T> T loadAs(String resource, Class<T> type) {
        String configFile = (String)this.resourceProvider.apply(resource);
        try {
            return (T)this.getYaml().loadAs(configFile, type);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigLoaderException("Cannot read the content: " + e.getMessage(), e);
        }
    }

    public <T> T loadAs(Path file, Class<T> type) {
        String configFile = new FileProvider(file).readAndProcess();
        try {
            return (T)this.getYaml().loadAs(configFile, type);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigLoaderException("Cannot read the content: " + e.getMessage(), e);
        }
    }

    public Map<String, Object> load(String resource) {
        return this.loadAs(resource, Map.class);
    }

    public Map<String, Object> load(Path file) {
        return this.loadAs(file, Map.class);
    }

    public ConfigLoader withResourceProvider(UnaryOperator<String> resourceProvider) {
        this.resourceProvider = resourceProvider;
        return this;
    }

    public ConfigLoader withTag(String tagName, Function<String, ?> scalarTagResolver) {
        this.tags.put(tagName, scalarTagResolver);
        return this;
    }

    private Yaml getYaml() {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        return new Yaml((BaseConstructor)new Constructor(){
            {
                ConfigLoader.this.tags.forEach((tag, function) -> this.yamlConstructors.put(new Tag("!" + tag), new ScalarTagConstructor((Function<String, ?>)function)));
            }

            class ScalarTagConstructor
            extends AbstractConstruct {
                private Function<String, ?> converter;

                public ScalarTagConstructor(Function<String, ?> converter) {
                    this.converter = converter;
                }

                public Object construct(Node node) {
                    if (!(node instanceof ScalarNode)) {
                        throw new ConfigLoaderException("Cannot load non scalar node with scalar function: " + node.getAnchor());
                    }
                    return this.converter.apply(this.constructScalar((ScalarNode)node));
                }
            }
        }, representer);
    }
}

