/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.lightweightconfig.properties;

import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Properties;
import uk.org.webcompere.lightweightconfig.ConfigLoaderException;
import uk.org.webcompere.lightweightconfig.provider.FileProvider;
import uk.org.webcompere.lightweightconfig.provider.ResourceProvider;

public class PropertiesLoader {
    public static Properties load(String resourceName) {
        Properties properties = new Properties();
        StringReader reader = new StringReader(ResourceProvider.readAndProcessResource(resourceName));
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new ConfigLoaderException("Cannot read properties file: " + e.getMessage(), e);
        }
        return properties;
    }

    public static Properties load(Path path) {
        Properties properties = new Properties();
        StringReader reader = new StringReader(new FileProvider(path).readAndProcess());
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new ConfigLoaderException("Cannot read properties file: " + e.getMessage(), e);
        }
        return properties;
    }
}

