/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.lightweightconfig.provider;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.org.webcompere.lightweightconfig.ConfigLoaderException;
import uk.org.webcompere.lightweightconfig.data.ImportAwarePlaceholderResolver;

public class FileProvider {
    private Path currentFile;

    public FileProvider(Path currentFile) {
        this.currentFile = currentFile;
    }

    public String readAndProcess() {
        return this.readAndProcessFile().collect(Collectors.joining("\n"));
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Converting known exception")
    private Stream<String> readAndProcessFile() {
        Stream<String> stream;
        block8: {
            Stream<String> stream2 = Files.lines(this.currentFile);
            try {
                stream = this.process(stream2).collect(Collectors.toList()).stream();
                if (stream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    throw new ConfigLoaderException("Cannot read stream: " + this.currentFile.toAbsolutePath(), e);
                }
            }
            stream2.close();
        }
        return stream;
    }

    private Stream<String> process(Stream<String> linesOfConfig) {
        return linesOfConfig.flatMap(line -> ImportAwarePlaceholderResolver.processLine(line, file -> this.resolvePath((String)file).readAndProcessFile()));
    }

    private FileProvider resolvePath(String file) {
        Path parent = this.currentFile.getParent();
        if (parent == null) {
            throw new ConfigLoaderException("Cannot resolve " + file + " against path " + this.currentFile.toAbsolutePath() + ": no parent path");
        }
        return new FileProvider(parent.resolve(file));
    }
}

