/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.lightweightconfig.provider;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.org.webcompere.lightweightconfig.ConfigLoaderException;
import uk.org.webcompere.lightweightconfig.data.ImportAwarePlaceholderResolver;

public class ResourceProvider {
    public static final String LINE_DELIMITER = "\n";

    public static String readAndProcessResource(String resourcePath) {
        return ResourceProvider.readAndProcessResourceLines(resourcePath).collect(Collectors.joining(LINE_DELIMITER));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Converting known exception")
    private static Stream<String> readAndProcessResourceLines(String resourcePath) {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);){
            Stream<String> stream2;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                stream2 = ResourceProvider.process(reader.lines()).collect(Collectors.toList()).stream();
            }
            return stream2;
        }
        catch (IOException | NullPointerException e) {
            throw new ConfigLoaderException("Cannot read stream: " + resourcePath, e);
        }
    }

    private static Stream<String> process(Stream<String> linesOfConfig) {
        return linesOfConfig.flatMap(line -> ImportAwarePlaceholderResolver.processLine(line, ResourceProvider::readAndProcessResourceLines));
    }
}

