/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import java.util.function.Predicate;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;

public class PredicateWrappedCondition
implements Condition {
    private Optional<Condition> delegate;
    private Predicate<JsonNode> typeDetector;
    private String typeName;

    public PredicateWrappedCondition(String typeName, Predicate<JsonNode> typeDetector) {
        this.typeDetector = typeDetector;
        this.delegate = Optional.empty();
        this.typeName = typeName;
    }

    public PredicateWrappedCondition(String typeName, Predicate<JsonNode> typeDetector, Condition delegate) {
        this.delegate = Optional.ofNullable(delegate);
        this.typeDetector = typeDetector;
        this.typeName = typeName;
    }

    @Override
    public Result test(JsonNode json) {
        if (!this.typeDetector.test(json)) {
            return new Result(this.describe(), json.getNodeType().toString(), false);
        }
        return this.delegate.map(del -> del.test(json)).orElse(new Result(this.describe(), json.getNodeType().toString(), true));
    }

    @Override
    public String describe() {
        return this.typeName + " node" + this.delegate.map(del -> " " + del.describe()).orElse("");
    }
}

