/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition.tree;

import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.condition.tree.Location;
import uk.org.webcompere.modelassert.json.condition.tree.PathMatch;
import uk.org.webcompere.modelassert.json.condition.tree.TreeRule;

public class PathRule {
    private PathMatch pathMatch;
    private TreeRule rule;
    private Condition ruleCondition;

    public PathRule(TreeRule rule) {
        this(PathMatch.all(), rule);
    }

    public PathRule(PathMatch pathMatch, TreeRule rule) {
        this.pathMatch = pathMatch;
        this.rule = rule;
        this.ruleCondition = null;
    }

    public PathRule(PathMatch pathMatch, Condition ruleCondition) {
        this.pathMatch = pathMatch;
        this.rule = TreeRule.CONDITION;
        this.ruleCondition = ruleCondition;
    }

    public boolean matches(Location location) {
        return this.pathMatch.matches(location);
    }

    public TreeRule getRule() {
        return this.rule;
    }

    public Condition getRuleCondition() {
        return this.ruleCondition;
    }

    public String toString() {
        return "at " + this.pathMatch + " " + (Object)((Object)this.rule) + " " + (this.ruleCondition != null ? this.ruleCondition.describe() : "");
    }
}

