/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class GPSSportsInformationRecorder {
    public static void main(String[] args) {
        FileInputStream depthFinderIn;
        String gpsString = "/dev/ttyAMA0";
        String screenString = "/dev/ttyUSB0";
        String depthFinderString = "/dev/ttyUSB1";
        String reportingString = "";
        boolean displayDepth = false;
        boolean useKeyboardInput = false;
        boolean knots = false;
        boolean coordinates = false;
        block57: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--display": 
                case "--show": {
                    block58: for (String p : args[++i].split(",")) {
                        switch (p.trim()) {
                            case "ll": 
                            case "longlat": 
                            case "degrees": {
                                coordinates = false;
                                continue block58;
                            }
                            case "xy": 
                            case "coordinate": 
                            case "metres": {
                                coordinates = true;
                                continue block58;
                            }
                            case "k": 
                            case "kt": {
                                knots = true;
                                continue block58;
                            }
                            case "m": 
                            case "mps": {
                                knots = false;
                                continue block58;
                            }
                            case "a": 
                            case "altitude": {
                                displayDepth = false;
                                continue block58;
                            }
                            case "d": 
                            case "depth": {
                                displayDepth = true;
                            }
                        }
                    }
                    continue block57;
                }
                case "-g": 
                case "--gps": {
                    gpsString = args[++i];
                    continue block57;
                }
                case "-d": 
                case "--depthfinder": {
                    gpsString = args[++i];
                    continue block57;
                }
                case "-s": 
                case "--screen": {
                    screenString = args[++i];
                    continue block57;
                }
                case "-i": 
                case "--keyboardinput": {
                    useKeyboardInput = true;
                    continue block57;
                }
                case "-r": 
                case "--report": {
                    reportingString = args[++i];
                    continue block57;
                }
                case "-h": 
                case "--help": {
                    System.out.println("gps [[-g|--gps] file]");
                    System.out.println("    [[-d|--depthfinder] file]");
                    System.out.println("    [[-s|--screen] file]");
                    System.out.println("    [[-i|--keyboardinput]");
                    System.out.println("    [[--display|--show] [[ll|longlat|degrees|xy|coordinate|metres|k|kt|m|mps|a|altitude|d|depth],]* ]");
                    System.out.println("    [[-r|--report] reportingswitches]");
                    System.out.println("    [-h|--help]");
                    System.exit(MDTService.Exitcode.EXIT_OK.rc);
                    continue block57;
                }
                default: {
                    System.err.println(String.format("Unknown switch: %s", args[i]));
                    System.exit(MDTService.Exitcode.EXIT_PROGFAIL.rc);
                }
            }
        }
        FileInputStream gpsIn = null;
        try {
            gpsIn = new FileInputStream(gpsString);
        }
        catch (FileNotFoundException ex) {
            System.err.println(String.format("GPS file does not exist: %s", gpsString));
            System.exit(MDTService.Exitcode.EXIT_PROGFAIL.rc);
        }
        FileOutputStream screenOut = null;
        try {
            screenOut = new FileOutputStream(screenString);
        }
        catch (FileNotFoundException ex) {
            System.err.println(String.format("Screen Output file does not exist: %s", screenString));
            System.exit(MDTService.Exitcode.EXIT_PROGFAIL.rc);
        }
        FileInputStream screenIn = null;
        try {
            screenIn = new FileInputStream(screenString);
        }
        catch (FileNotFoundException ex) {
            System.err.println(String.format("Screen Input file does not exist: %s", screenString));
            System.exit(MDTService.Exitcode.EXIT_PROGFAIL.rc);
        }
        try {
            depthFinderIn = new FileInputStream(depthFinderString);
        }
        catch (FileNotFoundException ex) {
            depthFinderIn = null;
        }
        Reporting.setReportingLevels((String)reportingString);
        new Controller(gpsIn, screenOut, screenIn, depthFinderIn, useKeyboardInput, coordinates, displayDepth, knots).start();
    }

    public static enum Command {
        CLOSE,
        START,
        STOP,
        GPSINFO,
        DEPTHINFO,
        INCDEPTH,
        DECDEPTH,
        BUTTON;

    }
}

