/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey;

public class GPSTime {
    private final int hours;
    private final int minutes;
    private final int seconds;

    public GPSTime(int hours, int minutes, int seconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d", this.hours, this.minutes, this.seconds);
    }

    public String toISOString() {
        return String.format("%02d%02d%02d", this.hours, this.minutes, this.seconds);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + this.hours;
        hash = 53 * hash + this.minutes;
        hash = 53 * hash + this.seconds;
        return hash;
    }

    public boolean equals(Object t) {
        if (!(t instanceof GPSTime)) {
            return false;
        }
        GPSTime time = (GPSTime)t;
        return time.hours == this.hours && time.minutes == this.minutes && time.seconds == this.seconds;
    }

    public boolean prior(GPSTime t) {
        if (t == null) {
            return false;
        }
        if (this.hours != t.hours) {
            return this.hours < t.hours;
        }
        if (this.minutes != t.minutes) {
            return this.minutes < t.minutes;
        }
        return this.seconds < t.seconds;
    }
}

