/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey;

import java.util.Objects;

public class Latitude {
    private final double value;

    public Latitude(double value) {
        this.value = value;
    }

    public Latitude(double value, char direction) {
        this.value = (double)(direction == 'N' ? 1 : -1) * value;
    }

    public double get() {
        return this.value;
    }

    public double getAbsolute() {
        return Math.abs(this.value);
    }

    public char getDirection() {
        return this.value >= 0.0 ? (char)'N' : 'S';
    }

    public Latitude clone() {
        return new Latitude(this.value);
    }

    public String toString() {
        return String.format("%11.6f", this.value);
    }

    public String toStringWithUnits() {
        return String.format("%11.6f\u00b0", this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof Latitude) {
            Latitude otherLat = (Latitude)other;
            return this.toString().equals(otherLat.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.value) << 6;
    }
}

