/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey;

import java.util.Objects;

public class Longitude {
    private final double value;

    public Longitude(double value) {
        this.value = value;
    }

    public Longitude(double value, char direction) {
        this.value = (double)(direction == 'E' ? 1 : -1) * value;
    }

    public double get() {
        return this.value;
    }

    public double getAbsolute() {
        return Math.abs(this.value);
    }

    public char getDirection() {
        return this.value >= 0.0 ? (char)'E' : 'W';
    }

    public Longitude clone() {
        return new Longitude(this.value);
    }

    public String toString() {
        return String.format("%11.6f", this.value);
    }

    public String toStringWithUnits() {
        return String.format("%11.6f\u00b0", this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof Longitude) {
            Longitude otherLong = (Longitude)other;
            return this.toString().equals(otherLong.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

