/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey;

import uk.theretiredprogrammer.gpssurvey.Coordinate;
import uk.theretiredprogrammer.gpssurvey.Course;
import uk.theretiredprogrammer.gpssurvey.Distance;
import uk.theretiredprogrammer.gpssurvey.Latitude;
import uk.theretiredprogrammer.gpssurvey.Longitude;

public class Position {
    private static final double metresPerDegreeLat = 111194.92664455873;
    public final Latitude latitude;
    public final Longitude longitude;
    public final Coordinate x;
    public final Coordinate y;
    public final Distance distance;
    public final Course course;

    public Position(Latitude latitude, Longitude longitude) {
        this(latitude, longitude, null);
    }

    public Position(Position from, Position to) {
        this(to.latitude, to.longitude, from);
    }

    public Position(Latitude latitude, Longitude longitude, Position origin) {
        this.latitude = latitude;
        this.longitude = longitude;
        if (origin != null) {
            double angle;
            double avLat = (origin.latitude.get() + latitude.get()) / 2.0;
            double metresPerDegreeLong = 111194.92664455873 * Math.cos(Math.toRadians(avLat));
            double yval = (origin.longitude.get() - longitude.get()) * metresPerDegreeLong;
            double xval = (origin.latitude.get() - latitude.get()) * 111194.92664455873;
            this.y = new Coordinate(yval);
            this.x = new Coordinate(xval);
            this.distance = new Distance(Math.sqrt(xval * xval + yval * yval));
            for (angle = Math.toDegrees(Math.atan2(xval, yval)); angle < 0.0; angle += 360.0) {
            }
            this.course = new Course(angle);
        } else {
            this.y = new Coordinate(0.0);
            this.x = new Coordinate(0.0);
            this.distance = new Distance(0.0);
            this.course = new Course(0.0);
        }
    }

    private Position(Latitude latitude, Longitude longitude, Coordinate x, Coordinate y, Distance distance, Course course) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.x = x;
        this.y = y;
        this.distance = distance;
        this.course = course;
    }

    public Position clone() {
        return new Position(this.latitude.clone(), this.longitude.clone(), this.x.clone(), this.y.clone(), this.distance.clone(), this.course.clone());
    }

    public boolean equals(Object other) {
        if (other instanceof Position) {
            Position otherp = (Position)other;
            return this.x.equals(otherp.x) && this.y.equals(otherp.y);
        }
        return false;
    }

    public int hashCode() {
        return this.latitude.hashCode() + this.longitude.hashCode();
    }
}

