/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.depthfinder;

import java.io.InputStream;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.depthfinder.DepthFinderSentenceListener;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class DepthFinderReader
extends MDThread<GPSSportsInformationRecorder.Command> {
    private final SentenceReader reader;
    private boolean running = false;

    public static void createAndStart(InputStream depthfinderIn) {
        DepthFinderReader thread = new DepthFinderReader(depthfinderIn);
        thread.start();
        thread.sendMessage((Object)GPSSportsInformationRecorder.Command.START);
    }

    private DepthFinderReader(InputStream depthfinderIn) {
        super("Depth Finder Reader", (Object)GPSSportsInformationRecorder.Command.CLOSE);
        this.reader = new SentenceReader(depthfinderIn);
        this.reader.addSentenceListener((SentenceListener)new DepthFinderSentenceListener());
        Reporting.registerControl((String)"DepthFinderReader", (char)'d');
    }

    protected void processMessage(GPSSportsInformationRecorder.Command command, Object commandParameters) {
        Reporting.report((String)"Depth Finder Reader", (int)3, (String)"Processing command %s", (Object)((Object)command));
        switch (command) {
            case START: {
                if (this.running) break;
                Reporting.report((String)"Depth Finder Reader", (int)1, (String)"Started");
                this.reader.start();
                this.running = true;
                break;
            }
            case STOP: {
                if (!this.running) break;
                Reporting.report((String)"Depth Finder Reader", (int)1, (String)"Stopped");
                this.reader.stop();
                this.running = false;
                break;
            }
            case CLOSE: {
                if (!this.running) break;
                Reporting.report((String)"Depth Finder Reader", (int)1, (String)"Stopped");
                this.reader.stop();
            }
        }
    }
}

