/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.depthfinder;

import java.io.IOException;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.sentence.DPTSentence;
import net.sf.marineapi.nmea.sentence.MTWSentence;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.VHWSentence;
import uk.theretiredprogrammer.gpssurvey.depthfinder.DepthFinderMessageConsolidator;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;

public class DepthFinderSentenceListener
implements SentenceListener {
    private final DepthFinderMessageConsolidator messageconsolidator = new DepthFinderMessageConsolidator();

    public void sentenceRead(SentenceEvent event) {
        try {
            Sentence s = event.getSentence();
            if (s instanceof VHWSentence) {
                this.messageconsolidator.insertVHW((VHWSentence)s);
            } else if (s instanceof MTWSentence) {
                this.messageconsolidator.insertMTW((MTWSentence)s);
            } else if (s instanceof DPTSentence) {
                this.messageconsolidator.insertDPT((DPTSentence)s);
            }
        }
        catch (IOException ex) {
            MDTService.reportExceptionAndExit((Exception)ex, (MDTService.Exitcode)MDTService.Exitcode.EXIT_PROGFAIL);
        }
    }

    public void readingPaused() {
    }

    public void readingStarted() {
    }

    public void readingStopped() {
    }
}

