/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.depthfinder;

import java.io.IOException;
import java.util.TimerTask;
import uk.theretiredprogrammer.gpssurvey.Depth;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.depthfinder.DepthFinderMessageConsolidator;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class ManualDepthListener
extends MDThread<GPSSportsInformationRecorder.Command> {
    private static final double DEPTHSTEPSIZE = 0.25;
    private double depth = 0.0;
    private Ticker ticker;
    private boolean operational = false;
    private static final int TICKINTERVAL = 1000;

    public static void createAndStart() {
        ManualDepthListener thread = new ManualDepthListener();
        thread.start();
        thread.sendMessage((Object)GPSSportsInformationRecorder.Command.START);
    }

    private ManualDepthListener() {
        super("Manual Depth Listener", (Object)GPSSportsInformationRecorder.Command.CLOSE);
        Reporting.registerControl((String)"Manual Depth Listener", (char)'m');
    }

    protected void processMessage(GPSSportsInformationRecorder.Command command, Object commandParameters) throws IOException {
        Reporting.report((String)"Manual Depth Listener", (int)3, (String)"Processing command %s", (Object)((Object)command));
        switch (command) {
            case START: {
                this.operational = true;
                this.ticker = new Ticker();
                MDTService.timerSchedule((TimerTask)this.ticker, (long)1000L, (long)1000L);
                break;
            }
            case STOP: {
                if (!this.operational) break;
                this.ticker.cancel();
                break;
            }
            case CLOSE: {
                if (!this.operational) break;
                this.ticker.cancel();
                this.operational = false;
                break;
            }
            case INCDEPTH: {
                if (!this.operational) break;
                this.depth += 0.25;
                this.sendDepthMessage();
                break;
            }
            case DECDEPTH: {
                if (!this.operational) break;
                this.depth -= 0.25;
                if (this.depth < 0.0) {
                    this.depth = 0.0;
                }
                this.sendDepthMessage();
            }
        }
    }

    private void sendDepthMessage() throws IOException {
        Reporting.report((String)"Manual Depth Listener", (int)4, (String)"Sending Depth Message to Information Store");
        DepthFinderMessageConsolidator.ConsolidatedDepthFinderData msg = new DepthFinderMessageConsolidator.ConsolidatedDepthFinderData();
        msg.depth = new Depth(this.depth);
        MDTService.sendMessage((String)"Controller", (Object)((Object)GPSSportsInformationRecorder.Command.DEPTHINFO), (Object)msg);
    }

    private class Ticker
    extends TimerTask {
        private Ticker() {
        }

        @Override
        public void run() {
            try {
                ManualDepthListener.this.sendDepthMessage();
            }
            catch (IOException ex) {
                MDTService.reportExceptionAndExit((Exception)ex, (MDTService.Exitcode)MDTService.Exitcode.EXIT_PROGFAIL);
            }
        }
    }
}

