/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.gpsreader;

import java.io.IOException;
import net.sf.marineapi.nmea.sentence.GGASentence;
import net.sf.marineapi.nmea.sentence.GSASentence;
import net.sf.marineapi.nmea.sentence.RMCSentence;
import net.sf.marineapi.nmea.sentence.VTGSentence;
import net.sf.marineapi.nmea.util.CompassPoint;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Date;
import net.sf.marineapi.nmea.util.FaaMode;
import net.sf.marineapi.nmea.util.GpsFixQuality;
import net.sf.marineapi.nmea.util.GpsFixStatus;
import net.sf.marineapi.nmea.util.Time;
import uk.theretiredprogrammer.gpssurvey.Altitude;
import uk.theretiredprogrammer.gpssurvey.GPSDate;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.GPSTime;
import uk.theretiredprogrammer.gpssurvey.HDOP;
import uk.theretiredprogrammer.gpssurvey.Latitude;
import uk.theretiredprogrammer.gpssurvey.Longitude;
import uk.theretiredprogrammer.gpssurvey.Position;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class GPSMessageConsolidator {
    private ConsolidatedGPSData gpsdata = null;
    private GPSTime oldtime = null;

    public void insertGGA(GGASentence s) {
        Reporting.report((String)"GPS Reader", (int)4, (String)"GGA sentence presented for processing");
        Reporting.report((String)"GPS Reader", (int)6, (String)"%s", (Object)s);
        if (s.getFixQuality() == GpsFixQuality.INVALID) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"GGA fix quality INVALID");
            return;
        }
        Time t = s.getTime();
        GPSTime time = new GPSTime(t.getHour(), t.getMinutes(), (int)t.getSeconds());
        if (time.prior(this.oldtime)) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"Ignoring historical GGA sentence at %s (previous time %s)\n%s", (Object)time.toString(), (Object)this.oldtime.toString(), (Object)s);
            return;
        }
        if (this.gpsdata == null) {
            this.gpsdata = new ConsolidatedGPSData();
        }
        this.gpsdata.time = time;
        this.oldtime = time;
        net.sf.marineapi.nmea.util.Position p = s.getPosition();
        this.gpsdata.altitude = new Altitude(p.getAltitude());
        this.gpsdata.position = new Position(new Latitude(p.getLatitude(), p.getLatitudeHemisphere() == CompassPoint.SOUTH ? (char)'S' : 'N'), new Longitude(p.getLongitude(), p.getLongitudeHemisphere() == CompassPoint.WEST ? (char)'W' : 'E'));
        this.gpsdata.satelliteCount = s.getSatelliteCount();
        this.gpsdata.setup |= 1;
    }

    public void insertGSA(GSASentence s) throws IOException {
        Reporting.report((String)"GPS Reader", (int)4, (String)"GSA sentence presented for processing");
        Reporting.report((String)"GPS Reader", (int)6, (String)"%s", (Object)s);
        GpsFixStatus gpsfixstatus = s.getFixStatus();
        if (gpsfixstatus != GpsFixStatus.GPS_3D) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"GSA Fix status != GPS_3D");
            return;
        }
        if (this.gpsdata == null) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"GSA sentence ignored - no GGA sentence preceeds");
            return;
        }
        this.gpsdata.hDOP = new HDOP(s.getHorizontalDOP());
        this.gpsdata.setup |= 2;
        if (this.gpsdata.setup == 15) {
            this.sendMessage();
        }
    }

    public void insertVTG(VTGSentence s) throws IOException {
        Reporting.report((String)"GPS Reader", (int)4, (String)"VTG sentence presented for processing");
        Reporting.report((String)"GPS Reader", (int)6, (String)"%s", (Object)s);
        if (s.getMode() != FaaMode.AUTOMATIC) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"VTG FaaMode is not AUTOMATIC");
            return;
        }
        if (this.gpsdata == null) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"VTG sentence ignored - no GGA sentence preceeds");
            return;
        }
        this.gpsdata.course = s.getTrueCourse();
        this.gpsdata.speed = s.getSpeedKmh() * 1000.0 / 3600.0;
        this.gpsdata.setup |= 4;
        if (this.gpsdata.setup == 15) {
            this.sendMessage();
        }
    }

    public void insertRMC(RMCSentence s) throws IOException {
        Reporting.report((String)"GPS Reader", (int)4, (String)"RMC sentence presented for processing");
        Reporting.report((String)"GPS Reader", (int)6, (String)"%s", (Object)s);
        if (s.getStatus() != DataStatus.ACTIVE) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"RMC Status is not ACTIVE");
            return;
        }
        if (this.gpsdata == null) {
            Reporting.report((String)"GPS Reader", (int)5, (String)"RMC sentence ignored - no GGA sentence preceeds");
            return;
        }
        Date d = s.getDate();
        this.gpsdata.date = new GPSDate(d.getDay(), d.getMonth(), d.getYear());
        this.gpsdata.setup |= 8;
        if (this.gpsdata.setup == 15) {
            this.sendMessage();
        }
    }

    private void sendMessage() throws IOException {
        Reporting.report((String)"GPS Reader", (int)4, (String)"Sentence set processed - information send to Information Centre");
        MDTService.sendMessage((String)"Controller", (Object)((Object)GPSSportsInformationRecorder.Command.GPSINFO), (Object)this.gpsdata);
        this.gpsdata = null;
    }

    public class ConsolidatedGPSData {
        public int setup = 0;
        public static final int GGASETUP = 1;
        public static final int GSASETUP = 2;
        public static final int VTGSETUP = 4;
        public static final int RMCSETUP = 8;
        public static final int ALLSETUP = 15;
        public GPSTime time;
        public Altitude altitude;
        public Position position;
        public int satelliteCount;
        public HDOP hDOP;
        public double course;
        public double speed;
        public GPSDate date;
    }
}

