/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.gpsreader;

import java.io.InputStream;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.gpsreader.GPSSentenceListener;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class GPSReader
extends MDThread<GPSSportsInformationRecorder.Command> {
    private final SentenceReader reader;
    private boolean running = false;

    public static void createAndStart(InputStream gpsIn) {
        GPSReader thread = new GPSReader(gpsIn);
        thread.start();
        thread.sendMessage((Object)GPSSportsInformationRecorder.Command.START);
    }

    private GPSReader(InputStream gpsIn) {
        super("GPS Reader", (Object)GPSSportsInformationRecorder.Command.CLOSE);
        this.reader = new SentenceReader(gpsIn);
        this.reader.addSentenceListener((SentenceListener)new GPSSentenceListener());
        Reporting.registerControl((String)"GPS Reader", (char)'g');
    }

    protected void processMessage(GPSSportsInformationRecorder.Command command, Object commandParameters) {
        Reporting.report((String)"GPS Reader", (int)3, (String)"Processing command %s", (Object)((Object)command));
        switch (command) {
            case START: {
                if (this.running) break;
                Reporting.report((String)"GPS Reader", (int)1, (String)"Started");
                this.reader.start();
                this.running = true;
                break;
            }
            case STOP: {
                if (!this.running) break;
                Reporting.report((String)"GPS Reader", (int)1, (String)"Stopped");
                this.reader.stop();
                this.running = false;
                break;
            }
            case CLOSE: {
                if (!this.running) break;
                Reporting.report((String)"GPS Reader", (int)1, (String)"Stopped");
                this.reader.stop();
            }
        }
    }
}

