/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.gpsreader;

import java.io.IOException;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.sentence.GGASentence;
import net.sf.marineapi.nmea.sentence.GSASentence;
import net.sf.marineapi.nmea.sentence.RMCSentence;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.VTGSentence;
import uk.theretiredprogrammer.gpssurvey.gpsreader.GPSMessageConsolidator;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;

public class GPSSentenceListener
implements SentenceListener {
    private final GPSMessageConsolidator messageconsolidator = new GPSMessageConsolidator();

    public void sentenceRead(SentenceEvent event) {
        try {
            Sentence s = event.getSentence();
            if (s instanceof GGASentence) {
                this.messageconsolidator.insertGGA((GGASentence)s);
            } else if (s instanceof GSASentence) {
                this.messageconsolidator.insertGSA((GSASentence)s);
            } else if (s instanceof VTGSentence) {
                this.messageconsolidator.insertVTG((VTGSentence)s);
            } else if (s instanceof RMCSentence) {
                this.messageconsolidator.insertRMC((RMCSentence)s);
            }
        }
        catch (IOException ex) {
            MDTService.reportExceptionAndExit((Exception)ex, (MDTService.Exitcode)MDTService.Exitcode.EXIT_PROGFAIL);
        }
    }

    public void readingPaused() {
    }

    public void readingStarted() {
    }

    public void readingStopped() {
    }
}

