/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.informationstore;

import com.pi4j.io.i2c.I2CFactory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.Depth;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.depthfinder.DepthFinderMessageConsolidator;
import uk.theretiredprogrammer.gpssurvey.depthfinder.DepthFinderReader;
import uk.theretiredprogrammer.gpssurvey.depthfinder.ManualDepthListener;
import uk.theretiredprogrammer.gpssurvey.gpsreader.GPSMessageConsolidator;
import uk.theretiredprogrammer.gpssurvey.gpsreader.GPSReader;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationCalculator;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.gpssurvey.informationstore.Recorder;
import uk.theretiredprogrammer.gpssurvey.informationstore.RecorderRecordWriter;
import uk.theretiredprogrammer.gpssurvey.informationstore.RecorderSessionWriter;
import uk.theretiredprogrammer.gpssurvey.informationstore.ReferencePointCalculator;
import uk.theretiredprogrammer.gpssurvey.input.IRControlAction;
import uk.theretiredprogrammer.gpssurvey.input.IrListener;
import uk.theretiredprogrammer.gpssurvey.input.KeyboardListener;
import uk.theretiredprogrammer.gpssurvey.ui.View;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplayOutputThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class Controller
extends MDThread<GPSSportsInformationRecorder.Command> {
    private static final LocationData INFORMATION = new LocationData();
    private final LocationCalculator locCalc = new LocationCalculator();
    private static final ReferencePointCalculator REFCALC = new ReferencePointCalculator();
    private static Recorder recorder;
    private static View view;
    private final boolean useManualDepth;

    public Controller(FileInputStream gpsIn, FileOutputStream screenOut, FileInputStream screenIn, FileInputStream depthfinderIn, boolean useKeyboardInput, boolean coordinates, boolean displayDepth, boolean knots) {
        super("Controller", (Object)GPSSportsInformationRecorder.Command.CLOSE, 6);
        this.useManualDepth = depthfinderIn == null;
        MDTService.enableShutdownHandler();
        Reporting.registerControl((String)"Controller", (char)'c');
        try {
            RecorderSessionWriter.createAndStart();
            RecorderRecordWriter.createAndStart();
            recorder = new Recorder();
            SerialTFTDisplayOutputThread.createAndStart((FileOutputStream)screenOut, (FileInputStream)screenIn);
            view = new View(screenOut, screenIn, coordinates, displayDepth, knots);
            GPSReader.createAndStart(gpsIn);
            if (this.useManualDepth) {
                ManualDepthListener.createAndStart();
            } else {
                DepthFinderReader.createAndStart(depthfinderIn);
            }
            if (useKeyboardInput) {
                KeyboardListener.createAndStart();
            } else {
                IrListener.createAndStart();
            }
        }
        catch (I2CFactory.UnsupportedBusNumberException | IOException e) {
            MDTService.reportExceptionAndExit((Exception)e, (MDTService.Exitcode)MDTService.Exitcode.EXIT_PROGFAIL);
        }
    }

    protected void processMessage(GPSSportsInformationRecorder.Command command, Object commandParameters) throws IOException {
        Reporting.report((String)"Controller", (int)3, (String)"Processing command %s", (Object)((Object)command));
        block0 : switch (command) {
            case CLOSE: {
                break;
            }
            case DEPTHINFO: {
                LocationData.Location ref;
                Depth depthdata = ((DepthFinderMessageConsolidator.ConsolidatedDepthFinderData)commandParameters).depth;
                if (this.locCalc.depthDataPoint(INFORMATION, depthdata)) {
                    recorder.locationChanged(INFORMATION);
                    view.dataChanged();
                }
                if ((ref = REFCALC.depthDataPoint(depthdata)) == null) break;
                INFORMATION.setReferenceLocation(ref);
                recorder.recordReferenceLocation(INFORMATION);
                view.dataChanged();
                break;
            }
            case GPSINFO: {
                LocationData.Location ref;
                GPSMessageConsolidator.ConsolidatedGPSData gpsdata = (GPSMessageConsolidator.ConsolidatedGPSData)commandParameters;
                if (this.locCalc.gpsDataPoint(INFORMATION, gpsdata)) {
                    recorder.locationChanged(INFORMATION);
                    view.dataChanged();
                }
                if ((ref = REFCALC.gpsDataPoint(gpsdata)) == null) break;
                INFORMATION.setReferenceLocation(ref);
                recorder.recordReferenceLocation(INFORMATION);
                view.dataChanged();
                break;
            }
            case BUTTON: {
                IRControlAction.Button button = (IRControlAction.Button)((Object)commandParameters);
                Reporting.report((String)"Controller", (int)3, (String)"Processing command %S BUTTON", (Object)((Object)button));
                switch (button) {
                    case POWERDOWN: {
                        view.displayPowerDown();
                        MDTService.fireShutdownHandler((MDTService.Exitcode)MDTService.Exitcode.EXIT_POWEROFF);
                        break block0;
                    }
                    case POWER: {
                        view.displayPowerDownSelection();
                        break block0;
                    }
                }
                view.processButtonInScreenContext(button, this.useManualDepth);
            }
        }
    }

    public static final LocationData getLocationData() {
        return INFORMATION;
    }

    public static final void obtainReferenceLocation() {
        REFCALC.start();
    }

    public static final void recordPoint() throws IOException {
        recorder.recordPoint(INFORMATION);
        view.dataChanged();
    }

    public static final void startStopRecording() throws IOException {
        recorder.startStopRecording(INFORMATION);
        view.dataChanged();
    }

    public static final void cancelRecording() throws IOException {
        recorder.cancelRecording(INFORMATION);
        view.dataChanged();
    }
}

