/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.informationstore;

import java.util.ArrayList;
import java.util.List;
import uk.theretiredprogrammer.gpssurvey.Altitude;
import uk.theretiredprogrammer.gpssurvey.Depth;
import uk.theretiredprogrammer.gpssurvey.HDOP;
import uk.theretiredprogrammer.gpssurvey.Position;
import uk.theretiredprogrammer.gpssurvey.gpsreader.GPSMessageConsolidator;

public class LocationData {
    private static final double MPS2KNOTS = 1.943844;
    private String datedisplay;
    private String isodatedisplay;
    private String timedisplay;
    private String isotimedisplay;
    private Location location;
    private double heading = 0.0;
    private double speed = 0.0;
    private double knots = 0.0;
    private Location refLocation;
    private Position startPosition;
    private List<Position> points = new ArrayList<Position>();
    private List<Position> startPoints = new ArrayList<Position>();
    private List<Position> endPoints = new ArrayList<Position>();
    private boolean recording = false;

    protected LocationData() {
        this.location = null;
        this.refLocation = null;
    }

    protected LocationData(GPSMessageConsolidator.ConsolidatedGPSData gpsdata) {
        this.setLocation(gpsdata);
    }

    protected final synchronized LocationData setLocation(GPSMessageConsolidator.ConsolidatedGPSData gpsdata) {
        Position p;
        this.timedisplay = gpsdata.time.toString();
        this.isotimedisplay = gpsdata.time.toISOString();
        this.datedisplay = gpsdata.date.toString();
        this.isodatedisplay = gpsdata.date.toISOString();
        Position position = p = this.refLocation != null ? new Position(this.refLocation.position, gpsdata.position) : gpsdata.position;
        if (this.location == null) {
            this.location = new Location(p, gpsdata.altitude, gpsdata.hDOP);
        } else {
            this.location.set(p, gpsdata.altitude, gpsdata.hDOP);
        }
        this.heading = gpsdata.course;
        this.speed = gpsdata.speed;
        this.knots = this.getSpeed() * 1.943844;
        return this;
    }

    protected final synchronized LocationData setReferenceLocation(Location location) {
        this.refLocation = location;
        return this;
    }

    public final synchronized String getDatedisplay() {
        return this.datedisplay;
    }

    public final synchronized String getIsodatedisplay() {
        return this.isodatedisplay;
    }

    public final synchronized String getTimedisplay() {
        return this.timedisplay;
    }

    public final synchronized String getIsotimedisplay() {
        return this.isotimedisplay;
    }

    public final synchronized Location getLocation() {
        return this.location;
    }

    public final synchronized double getHeading() {
        return this.heading;
    }

    public final synchronized double getSpeed() {
        return this.speed;
    }

    public final synchronized double getKnots() {
        return this.knots;
    }

    public final synchronized Position getPosition() {
        return this.getLocation().getPosition();
    }

    public final synchronized HDOP getHDOP() {
        return this.getLocation().getHDOP();
    }

    public final synchronized Altitude getAltitude() {
        return this.getLocation().getAltitude();
    }

    public final synchronized Depth getDepth() {
        return this.getLocation().getDepth();
    }

    public final synchronized Location getReferenceLocation() {
        return this.refLocation;
    }

    public final synchronized Position getStartPosition() {
        return this.startPosition;
    }

    public final synchronized void setStartPosition() {
        this.startPosition = this.getPosition();
    }

    public final synchronized void clearStartPosition() {
        this.startPosition = null;
    }

    public final synchronized List<Position> getPoints() {
        return this.points;
    }

    public final synchronized Position getCurrentFromLastPoint() {
        return new Position(this.points.get(this.points.size() - 1), this.getPosition());
    }

    public final synchronized Position getCurrentFromPoint(int i) {
        return new Position(this.points.get(i), this.getPosition());
    }

    public final synchronized Position getPointFromPreviousPoint(int i) {
        return new Position(this.points.get(i - 1), this.points.get(i));
    }

    public final synchronized boolean hasNoPoints() {
        return this.points.isEmpty();
    }

    public final synchronized int getPointsSize() {
        return this.points.size();
    }

    public final synchronized void addPoint() {
        this.points.add(this.getPosition());
    }

    public final synchronized List<Position> getStartPoints() {
        return this.startPoints;
    }

    public final synchronized List<Position> getEndPoints() {
        return this.endPoints;
    }

    public final synchronized void addStartEndPoints() {
        this.startPoints.add(this.startPosition);
        this.endPoints.add(this.getPosition());
    }

    public final synchronized Position getFirstStartEnd() {
        return new Position(this.startPoints.get(0), this.endPoints.get(0));
    }

    public final synchronized Position getCurrentFromStart() {
        return new Position(this.startPosition, this.getPosition());
    }

    public final synchronized Position getCurrentFromEnd() {
        return new Position(this.endPoints.get(this.endPoints.size() - 1), this.getPosition());
    }

    public final synchronized boolean hasNoStartEndPoints() {
        return this.startPoints.isEmpty();
    }

    public final synchronized int getStartEndPointsSize() {
        return this.startPoints.size();
    }

    public final synchronized boolean isRecording() {
        return this.recording;
    }

    public final synchronized void setRecording(boolean recording) {
        this.recording = recording;
    }

    public static class Location {
        private Position position;
        private HDOP hDOP;
        private Altitude altitude;
        private Depth depth;

        public Location(Position position, Altitude altitude, HDOP hDOP) {
            this.set(position, altitude, hDOP);
        }

        public Location(Position position, Altitude altitude, HDOP hDOP, Depth depth) {
            this.set(position, altitude, hDOP);
            this.setDepth(depth);
        }

        public Location clone() {
            return new Location(this.position.clone(), this.altitude.clone(), this.hDOP.clone(), this.depth == null ? null : this.depth.clone());
        }

        public final synchronized Location set(Position position, Altitude altitude, HDOP hDOP) {
            this.position = position;
            this.altitude = altitude;
            this.hDOP = hDOP;
            return this;
        }

        protected final synchronized Location setDepth(Depth depth) {
            this.depth = depth;
            return this;
        }

        public final synchronized Position getPosition() {
            return this.position;
        }

        public final synchronized HDOP getHDOP() {
            return this.hDOP;
        }

        public final synchronized Altitude getAltitude() {
            return this.altitude;
        }

        public final synchronized Depth getDepth() {
            return this.depth;
        }
    }
}

