/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.informationstore;

import java.io.File;
import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.Position;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class Recorder {
    private String filename;
    private boolean sessionfileopened = false;

    public Recorder() {
        Reporting.registerControl((String)"Recorder", (char)'r');
    }

    public void locationChanged(LocationData ld) throws IOException {
        LocationData.Location l = ld.getLocation();
        if (l != null && ld.isRecording()) {
            MDTService.sendMessage((String)"RecordWriter", (Object)((Object)RecordWriterCommand.WRITE), (Object)this.createRecord("RECORD", ld, l));
        }
    }

    public void startStopRecording(LocationData ld) throws IOException {
        if (ld.isRecording()) {
            MDTService.sendMessage((String)"RecordWriter", (Object)((Object)RecordWriterCommand.CLOSEFILE));
            this.writeToSessionFile("ENDRECORDING", ld, this.filename);
            ld.setRecording(false);
            ld.addStartEndPoints();
        } else {
            this.filename = String.format("recording_%s_%s.csv", ld.getIsodatedisplay(), ld.getIsotimedisplay());
            if (new File(this.filename).exists()) {
                String msg = String.format("Cannot start recording - file name already exists ( %s)", this.filename);
                this.filename = null;
                throw new IOException(msg);
            }
            LocationData.Location l = ld.getLocation();
            if (l != null) {
                MDTService.sendMessage((String)"RecordWriter", (Object)((Object)RecordWriterCommand.OPENFILE), (Object)this.filename);
                ld.setRecording(true);
                ld.setStartPosition();
                this.writeToSessionFile("RECORDING", ld);
                MDTService.sendMessage((String)"RecordWriter", (Object)((Object)RecordWriterCommand.WRITE), (Object)this.createRecord("RECORD", ld, l));
            }
        }
    }

    public void cancelRecording(LocationData ld) throws IOException {
        if (ld.isRecording()) {
            this.writeToSessionFile("CANCELRECORDING", ld);
            ld.setRecording(false);
            ld.clearStartPosition();
            MDTService.sendMessage((String)"RecordWriter", (Object)((Object)RecordWriterCommand.CANCELFILE));
        }
    }

    public boolean recordPoint(LocationData ld) throws IOException {
        LocationData.Location l = ld.getLocation();
        if (l != null) {
            this.writeToSessionFile("POSITION", ld, l);
            ld.addPoint();
            return true;
        }
        return false;
    }

    public boolean recordReferenceLocation(LocationData ld) throws IOException {
        LocationData.Location l = ld.getReferenceLocation();
        if (l != null) {
            this.writeToSessionFile("REFERENCE", ld, l);
            return true;
        }
        return false;
    }

    private void writeToSessionFile(String type, LocationData ld, LocationData.Location l) throws IOException {
        if (!this.sessionfileopened) {
            this.openSessionFile(ld);
        }
        MDTService.sendMessage((String)"SessionWriter", (Object)((Object)SessionWriterCommand.WRITE), (Object)this.createRecord(type, ld, l));
    }

    private void writeToSessionFile(String type, LocationData ld, String parameter) throws IOException {
        if (!this.sessionfileopened) {
            this.openSessionFile(ld);
        }
        StringBuilder sb = this.buildRecordHeader(type, ld);
        sb.append(',');
        sb.append(parameter);
        MDTService.sendMessage((String)"SessionWriter", (Object)((Object)SessionWriterCommand.WRITE), (Object)sb.toString());
    }

    private void writeToSessionFile(String type, LocationData ld) throws IOException {
        if (!this.sessionfileopened) {
            this.openSessionFile(ld);
        }
        MDTService.sendMessage((String)"SessionWriter", (Object)((Object)SessionWriterCommand.WRITE), (Object)this.buildRecordHeader(type, ld).toString());
    }

    private void openSessionFile(LocationData ld) throws IOException {
        String fname = String.format("session_%s_%s.csv", ld.getIsodatedisplay(), ld.getIsotimedisplay());
        if (new File(fname).exists()) {
            throw new IOException(String.format("Cannot open session recording file - file name already exists ( %s)", fname));
        }
        MDTService.sendMessage((String)"SessionWriter", (Object)((Object)SessionWriterCommand.OPENFILE), (Object)fname);
        this.sessionfileopened = true;
        this.writeToSessionFile("START", ld);
    }

    private StringBuilder buildRecordHeader(String type, LocationData ld) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append(',');
        sb.append(ld.getIsodatedisplay());
        sb.append(',');
        sb.append(ld.getIsotimedisplay());
        return sb;
    }

    private String createRecord(String type, LocationData ld, LocationData.Location l) {
        StringBuilder sb = this.buildRecordHeader(type, ld);
        sb.append(',');
        sb.append(l.getHDOP());
        sb.append(',');
        Position p = l.getPosition();
        sb.append(p.latitude.toString());
        sb.append(',');
        sb.append(p.longitude.toString());
        sb.append(',');
        sb.append(p.x.toString());
        sb.append(',');
        sb.append(p.y.toString());
        sb.append(',');
        sb.append(l.getAltitude().toString());
        sb.append(',');
        sb.append(l.getDepth().toString());
        return sb.toString();
    }

    protected static enum RecordWriterCommand {
        CLOSE,
        OPENFILE,
        WRITE,
        CLOSEFILE,
        CANCELFILE;

    }

    protected static enum SessionWriterCommand {
        CLOSE,
        OPENFILE,
        WRITE;

    }
}

