/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.informationstore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import uk.theretiredprogrammer.gpssurvey.informationstore.Recorder;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDThread;

public class RecorderRecordWriter
extends MDThread<Recorder.RecordWriterCommand> {
    public String filename = null;
    public List<String> lines;

    public static void createAndStart() {
        RecorderRecordWriter thread = new RecorderRecordWriter();
        thread.start();
    }

    private RecorderRecordWriter() {
        super("RecordWriter", (Object)Recorder.RecordWriterCommand.CLOSE, 50);
    }

    protected void processMessage(Recorder.RecordWriterCommand command, Object commandParameters) throws IOException {
        switch (command) {
            case CLOSE: {
                if (this.filename == null) break;
                this.filetostore();
                break;
            }
            case OPENFILE: {
                this.filename = (String)commandParameters;
                this.lines = new ArrayList<String>();
                break;
            }
            case CLOSEFILE: {
                this.filetostore();
                break;
            }
            case CANCELFILE: {
                this.filename = null;
                break;
            }
            case WRITE: {
                this.lines.add((String)commandParameters);
            }
        }
    }

    private void filetostore() throws FileNotFoundException {
        try (PrintWriter out = new PrintWriter(this.filename);){
            this.lines.stream().forEach(line -> out.println((String)line));
        }
        this.filename = null;
    }
}

