/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.informationstore;

import uk.theretiredprogrammer.gpssurvey.Altitude;
import uk.theretiredprogrammer.gpssurvey.Depth;
import uk.theretiredprogrammer.gpssurvey.HDOP;
import uk.theretiredprogrammer.gpssurvey.Latitude;
import uk.theretiredprogrammer.gpssurvey.Longitude;
import uk.theretiredprogrammer.gpssurvey.Position;
import uk.theretiredprogrammer.gpssurvey.gpsreader.GPSMessageConsolidator;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;

public class ReferencePointCalculator {
    private double latitude;
    private double longitude;
    private double altitude;
    private double depth;
    private double hDOP;
    private static final int REFSAMPLECOUNT = 5;
    private int gpsrefcounter;
    private int depthrefcounter;
    private boolean collectingreferencelocation = false;

    public final void start() {
        if (!this.collectingreferencelocation) {
            this.gpsrefcounter = 5;
            this.depthrefcounter = 5;
            this.collectingreferencelocation = true;
            this.depth = 0.0;
            this.latitude = 0.0;
            this.longitude = 0.0;
            this.altitude = 0.0;
            this.hDOP = 0.0;
        }
    }

    public LocationData.Location depthDataPoint(Depth depthdata) {
        if (this.collectingreferencelocation && this.depthrefcounter > 0) {
            this.depth += depthdata.get();
            --this.depthrefcounter;
            return this.isDataCollectionComplete();
        }
        return null;
    }

    public LocationData.Location gpsDataPoint(GPSMessageConsolidator.ConsolidatedGPSData gpsdata) {
        if (this.collectingreferencelocation && this.gpsrefcounter > 0) {
            this.latitude += gpsdata.position.latitude.get();
            this.longitude += gpsdata.position.longitude.get();
            this.altitude += gpsdata.altitude.get();
            this.hDOP += gpsdata.hDOP.get();
            --this.gpsrefcounter;
            return this.isDataCollectionComplete();
        }
        return null;
    }

    private LocationData.Location isDataCollectionComplete() {
        if (this.gpsrefcounter == 0 && this.depthrefcounter == 0) {
            this.depth /= 5.0;
            this.latitude /= 5.0;
            this.longitude /= 5.0;
            this.altitude /= 5.0;
            this.hDOP /= 5.0;
            this.collectingreferencelocation = false;
            return new LocationData.Location(new Position(new Latitude(this.latitude), new Longitude(this.longitude)), new Altitude(this.altitude), new HDOP(this.hDOP), new Depth(this.depth));
        }
        return null;
    }
}

