/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.input;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.input.IRControlAction;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class IrListener
extends MDThread<GPSSportsInformationRecorder.Command> {
    private static final byte INTERRUPT_DEVICE = 0;
    private static final byte IR_DEVICE = 1;
    private static final byte BUTTON_DEVICE = 2;
    private static final byte POWERDOWN_BUTTON = 1;
    private static final IRControlAction.Button[] MAPKEY2BUTTON = new IRControlAction.Button[]{IRControlAction.Button.POWER, IRControlAction.Button.A, IRControlAction.Button.B, IRControlAction.Button.C, IRControlAction.Button.UP, IRControlAction.Button.LEFT, IRControlAction.Button.SELECT, IRControlAction.Button.RIGHT, IRControlAction.Button.DOWN};
    private final GpioController gpio;
    private final GpioPinDigitalInput i2cInt;
    private final I2CDevice device;
    private InterruptListener interruptlistener;

    public static void createAndStart() throws IOException, I2CFactory.UnsupportedBusNumberException {
        IrListener thread = new IrListener();
        thread.start();
        thread.sendMessage((Object)GPSSportsInformationRecorder.Command.START);
    }

    private IrListener() throws IOException, I2CFactory.UnsupportedBusNumberException {
        super("IR Listener", (Object)GPSSportsInformationRecorder.Command.CLOSE);
        Reporting.registerControl((String)"IR Listener", (char)'i');
        this.gpio = GpioFactory.getInstance();
        this.i2cInt = this.gpio.provisionDigitalInputPin(RaspiPin.GPIO_07, "I2C interrupt");
        this.i2cInt.setShutdownOptions(Boolean.valueOf(true));
        I2CBus bus = I2CFactory.getInstance((int)1);
        this.device = bus.getDevice(96);
    }

    protected void processMessage(GPSSportsInformationRecorder.Command command, Object commandParameters) throws IOException {
        Reporting.report((String)"IR Listener", (int)3, (String)"Processing command %s", (Object)((Object)command));
        switch (command) {
            case START: {
                GpioPinListener[] gpioPinListenerArray = new GpioPinListener[1];
                this.interruptlistener = new InterruptListener();
                gpioPinListenerArray[0] = this.interruptlistener;
                this.i2cInt.addListener(gpioPinListenerArray);
                break;
            }
            case CLOSE: {
                this.i2cInt.removeListener(new GpioPinListener[]{this.interruptlistener});
                this.gpio.removeAllListeners();
                this.gpio.shutdown();
            }
        }
    }

    private class InterruptListener
    implements GpioPinListenerDigital {
        private InterruptListener() {
        }

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent gpdsce) {
            block11: {
                PinState pinstate = gpdsce.getState();
                if (pinstate.isLow()) {
                    try {
                        Reporting.report((String)"IR Listener", (int)3, (String)"Interrupt raised");
                        byte[] message = new byte[2];
                        int zcount = IrListener.this.device.read(message, 0, 2);
                        if (zcount == 2) {
                            byte dev = message[0];
                            byte key = message[1];
                            switch (dev) {
                                case 0: {
                                    Reporting.report((String)"IR Listener", (int)3, (String)"No message on 0x60");
                                    break;
                                }
                                case 2: {
                                    if (key == 1) {
                                        Reporting.report((String)"IR Listener", (int)3, (String)"Received Powerdown button");
                                        MDTService.sendMessage((String)"Controller", (Object)((Object)GPSSportsInformationRecorder.Command.BUTTON), (Object)((Object)IRControlAction.Button.POWERDOWN));
                                        break;
                                    }
                                    break block11;
                                }
                                case 1: {
                                    if (key > 0) {
                                        IRControlAction.Button b = MAPKEY2BUTTON[key - 1];
                                        Reporting.report((String)"IR Listener", (int)3, (String)("Received IR message: " + b.toString()));
                                        MDTService.sendMessage((String)"Controller", (Object)((Object)GPSSportsInformationRecorder.Command.BUTTON), (Object)((Object)b));
                                        break;
                                    }
                                    break block11;
                                }
                                default: {
                                    throw new IOException("illegal i2c reporting device - " + message[0]);
                                }
                            }
                            break block11;
                        }
                        throw new IOException("illegal i2c message length");
                    }
                    catch (IOException ex) {
                        MDTService.reportExceptionAndExit((Exception)ex, (MDTService.Exitcode)MDTService.Exitcode.EXIT_PROGFAIL);
                    }
                }
            }
        }
    }
}

