/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.input;

import java.io.IOException;
import java.util.TimerTask;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.input.IRControlAction;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class KeyboardListener
extends MDThread<GPSSportsInformationRecorder.Command> {
    private static final int POLLINTERVAL = 100;
    private static final String invalues = "q+/*-84562";
    private static final IRControlAction.Button[] inbuttons = new IRControlAction.Button[]{IRControlAction.Button.POWERDOWN, IRControlAction.Button.POWER, IRControlAction.Button.A, IRControlAction.Button.B, IRControlAction.Button.C, IRControlAction.Button.UP, IRControlAction.Button.LEFT, IRControlAction.Button.SELECT, IRControlAction.Button.RIGHT, IRControlAction.Button.DOWN};
    private Listener ticker;

    public static void createAndStart() {
        KeyboardListener thread = new KeyboardListener();
        thread.start();
        thread.sendMessage((Object)GPSSportsInformationRecorder.Command.START);
    }

    private KeyboardListener() {
        super("KB Listener", (Object)GPSSportsInformationRecorder.Command.CLOSE);
        Reporting.registerControl((String)"KB Listener", (char)'k');
    }

    protected void processMessage(GPSSportsInformationRecorder.Command command, Object commandParameters) throws IOException {
        Reporting.report((String)"KB Listener", (int)3, (String)"Processing command %s", (Object)((Object)command));
        switch (command) {
            case START: {
                this.ticker = new Listener();
                MDTService.timerSchedule((TimerTask)this.ticker, (long)100L, (long)100L);
                break;
            }
            case CLOSE: {
                this.ticker.cancel();
            }
        }
    }

    private class Listener
    extends TimerTask {
        private Listener() {
        }

        @Override
        public void run() {
            try {
                int inchar;
                int pos;
                if (System.in.available() > 0 && (pos = KeyboardListener.invalues.indexOf(inchar = System.in.read())) != -1) {
                    IRControlAction.Button b = inbuttons[pos];
                    Reporting.report((String)"KB Listener", (int)3, (String)("Received KB message: " + b.toString()));
                    MDTService.sendMessage((String)"Controller", (Object)((Object)GPSSportsInformationRecorder.Command.BUTTON), (Object)((Object)b));
                }
            }
            catch (IOException ex) {
                MDTService.reportExceptionAndExit((Exception)ex, (MDTService.Exitcode)MDTService.Exitcode.EXIT_PROGFAIL);
            }
        }
    }
}

