/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.ui;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.input.IRControlAction;
import uk.theretiredprogrammer.gpssurvey.ui.Action;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class ButtonActions
implements IRControlAction {
    private static final int MAXLINES = 7;
    private final String title;
    private final String[] lines = new String[7];
    private final IRControlAction.Button[] buttons = new IRControlAction.Button[7];
    private final Action[] actions = new Action[7];
    private int linecount = 0;
    private final String defaultline;
    private final Action defaultaction;

    public ButtonActions(String title, String defaultline, Action defaultaction) {
        this.title = title;
        this.defaultline = defaultline;
        this.defaultaction = defaultaction;
    }

    public ButtonActions(String title) {
        this(title, null, null);
    }

    public ButtonActions() {
        this("", null, null);
    }

    public ButtonActions addLine(IRControlAction.Button button, String text) throws IOException {
        return this.addLine(button, text, null);
    }

    public ButtonActions addLine(IRControlAction.Button button, Action action) throws IOException {
        return this.addLine(button, "", action);
    }

    public ButtonActions addLine(IRControlAction.Button button, String text, Action action) throws IOException {
        if (this.linecount >= 7) {
            throw new IOException("Too many menu lines added");
        }
        this.lines[this.linecount] = text;
        this.buttons[this.linecount] = button;
        this.actions[this.linecount++] = action;
        return this;
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.title);
        sb.append("\n\n");
        for (int i = 0; i < this.linecount; ++i) {
            sb.append(this.buttons[i].name());
            sb.append(" = ");
            sb.append(this.lines[i]);
            sb.append("\n");
        }
        if (this.defaultline != null) {
            sb.append("Other buttons = ");
            sb.append(this.defaultline);
        }
        return sb.toString();
    }

    @Override
    public boolean actionOnButton(IRControlAction.Button button) throws IOException {
        Reporting.report((String)"Screen", (int)3, (String)"ButtonMenu processing command %s", (Object)((Object)button));
        for (int i = 0; i < this.linecount; ++i) {
            if (button != this.buttons[i] || this.actions[i] == null) continue;
            this.actions[i].execute();
            return true;
        }
        if (this.defaultaction != null) {
            this.defaultaction.execute();
        }
        return false;
    }
}

