/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.ui;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.GPSSportsInformationRecorder;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.input.IRControlAction;
import uk.theretiredprogrammer.gpssurvey.ui.ButtonActions;
import uk.theretiredprogrammer.gpssurvey.ui.MainCommonButtonActions;
import uk.theretiredprogrammer.gpssurvey.ui.ScreenDataChangeProcessor;
import uk.theretiredprogrammer.gpssurvey.uiscreens.ConfirmAtReferenceLocationScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.FinishedScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.HeadingScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.LocationScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.ObtainingReferenceLocationInformationScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.PointDisplay2Screen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.PointDisplayScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.PositionScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.RecorderStatusScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.ReferenceLocationScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.SelectPowerDownOptionScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.SplashScreen;
import uk.theretiredprogrammer.gpssurvey.uiscreens.WaitingForGPSScreen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.ScreenManager;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.ScreenSet;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplayUsingOutputThread;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.MDTService;

public class View {
    private FinishedScreen finishedscreen;

    public View(FileOutputStream screenOut, FileInputStream screenIn, boolean displaycoordinates, boolean displaydepth, boolean displayknots) {
        try {
            SerialTFTDisplayUsingOutputThread display = new SerialTFTDisplayUsingOutputThread(screenOut, screenIn, SerialTFTDisplay.Orientation.LANDSCAPE, SerialTFTDisplay.Colour.BLUE, 101);
            ScreenManager.add((ScreenSet)new ScreenSet("setup", (Screen)new SplashScreen((SerialTFTDisplay)display)));
            ScreenManager.selectScreenSet((String)"setup").paint();
            ScreenManager.getScreenSet().add(new Screen[]{new WaitingForGPSScreen((SerialTFTDisplay)display), new ConfirmAtReferenceLocationScreen((SerialTFTDisplay)display, displaydepth), new ObtainingReferenceLocationInformationScreen((SerialTFTDisplay)display)});
            ScreenManager.add((ScreenSet)new ScreenSet("main", (Object)MainCommonButtonActions.getActions(), new Screen[]{new LocationScreen((SerialTFTDisplay)display, displaycoordinates, displaydepth), new ReferenceLocationScreen((SerialTFTDisplay)display, displaydepth), new PositionScreen((SerialTFTDisplay)display), new HeadingScreen((SerialTFTDisplay)display, displayknots), new RecorderStatusScreen((SerialTFTDisplay)display), new PointDisplayScreen((SerialTFTDisplay)display), new PointDisplay2Screen((SerialTFTDisplay)display)}));
            Screen[] screenArray = new Screen[2];
            screenArray[0] = new SelectPowerDownOptionScreen((SerialTFTDisplay)display);
            this.finishedscreen = new FinishedScreen((SerialTFTDisplay)display);
            screenArray[1] = this.finishedscreen;
            ScreenManager.add((ScreenSet)new ScreenSet("finish", screenArray));
        }
        catch (IOException e) {
            MDTService.reportExceptionAndExit((Exception)e, (MDTService.Exitcode)MDTService.Exitcode.EXIT_PROGFAIL);
        }
    }

    public synchronized void displayPowerDown() throws IOException {
        ScreenManager.switchScreenSet((String)"finish", (int)1);
        this.finishedscreen.setMessage("powering down...");
        this.finishedscreen.paint();
    }

    public synchronized void displayPowerDownSelection() throws IOException {
        if (!"finish".equals(ScreenManager.getCurrentScreenSetId())) {
            ScreenManager.switchScreenSet((String)"finish");
        }
    }

    public synchronized void processButtonInScreenContext(IRControlAction.Button button, boolean useManualDepth) throws IOException {
        Screen currentScreen = ScreenManager.getScreen();
        if (currentScreen instanceof IRControlAction && ((IRControlAction)currentScreen).actionOnButton(button)) {
            return;
        }
        ScreenSet currentScreenSet = ScreenManager.getScreenSet();
        ButtonActions actions = (ButtonActions)currentScreenSet.getActions();
        if (actions != null && actions.actionOnButton(button)) {
            return;
        }
        if (useManualDepth) {
            switch (button) {
                case UP: {
                    MDTService.sendMessage((String)"Manual Depth Listener", (Object)((Object)GPSSportsInformationRecorder.Command.INCDEPTH));
                    break;
                }
                case DOWN: {
                    MDTService.sendMessage((String)"Manual Depth Listener", (Object)((Object)GPSSportsInformationRecorder.Command.DECDEPTH));
                }
            }
        }
    }

    public synchronized void dataChanged() throws IOException {
        Screen currentScreen = ScreenManager.getScreen();
        if (currentScreen instanceof ScreenDataChangeProcessor) {
            ((ScreenDataChangeProcessor)currentScreen).dataChanged(Controller.getLocationData());
        }
    }

    public static synchronized void displayNextScreenAndExit(MDTService.Exitcode exitcode, String message) throws IOException {
        Screen nextScreen = ScreenManager.getScreenSet().next();
        if (nextScreen instanceof FinishedScreen) {
            ((FinishedScreen)nextScreen).setMessage(message);
            nextScreen.paint();
        }
        MDTService.fireShutdownHandler((MDTService.Exitcode)exitcode);
    }

    public static synchronized void displayNextScreen() throws IOException {
        ScreenManager.getScreenSet().next();
    }

    public static synchronized void displayPreviousScreen() throws IOException {
        ScreenManager.getScreenSet().previous();
    }

    public static synchronized void displayPreviousScreenSet() throws IOException {
        ScreenManager.popScreenSet();
    }

    public static synchronized void displayNewScreenSet(String name) throws IOException {
        ScreenManager.switchScreenSet((String)name);
    }

    public static synchronized void displayRepaint() throws IOException {
        ScreenManager.getScreen().paint();
    }
}

