/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.ui;

import java.io.IOException;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.VariableBarWidget;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;

public class WaitingForZone
implements Zone {
    private final TextZone msg;
    private static final PixelPosition msgpos = new PixelPosition(0, 10);
    private static final HybridArea msgsize = new HybridArea(160, 4);
    private final VariableBarWidget progressbar;
    private static final PixelPosition progressbarpos = new PixelPosition(20, 111);
    private static final PixelArea progressbarsize = new PixelArea(120, 10);
    private static final int MINCOUNT = 0;
    private static final int MAXCOUNT = 10;
    private int count = 1;
    private boolean countup = true;

    public WaitingForZone(SerialTFTDisplay display, String message) throws IOException {
        this.msg = new TextZone(display, msgpos, msgsize, SerialTFTDisplay.Font.SIZE_10x20, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre().setForeground(SerialTFTDisplay.Colour.WHITE);
        this.msg.insert(message);
        this.progressbar = new VariableBarWidget(display, progressbarpos, progressbarsize, 0.0, 10.0, SerialTFTDisplay.Colour.GREEN, display.getBackground());
    }

    public void onTick() {
        if (this.count == 0) {
            this.countup = true;
            this.progressbar.invert();
        }
        if (this.count == 10) {
            this.countup = false;
            this.progressbar.invert();
        }
        this.count = this.countup ? ++this.count : --this.count;
        this.progressbar.setValue((double)this.count);
    }

    public void paint() throws IOException {
        this.paint(false);
    }

    public void paint(boolean force) throws IOException {
        this.msg.paint(force);
        this.progressbar.paint(force);
    }
}

