/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.HDOP;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.gpssurvey.input.IRControlAction;
import uk.theretiredprogrammer.gpssurvey.ui.ScreenDataChangeProcessor;
import uk.theretiredprogrammer.gpssurvey.ui.View;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.CharacterArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.VariableLogBarWidget;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;
import uk.theretiredprogrammer.rpiembeddedlibrary.thread.Reporting;

public class ConfirmAtReferenceLocationScreen
extends Screen
implements IRControlAction,
ScreenDataChangeProcessor {
    private static final int LABELWIDTH = 70;
    private static final HybridArea fullwidthx1 = new HybridArea(160, 1);
    private static final HybridArea fullwidthx2 = new HybridArea(160, 2);
    private static final HybridArea labelwidthx1 = new HybridArea(70, 1);
    private static final HybridArea fieldwidthx1 = new HybridArea(90, 1);
    private final TextZone header;
    private static final PixelPosition headerpos = new PixelPosition(0, 0);
    private final TextZone northlabel;
    private static final PixelPosition northlabelpos = new PixelPosition(0, 24);
    private final TextZone north;
    private static final PixelPosition northpos = new PixelPosition(70, 24);
    private final TextZone eastlabel;
    private static final PixelPosition eastlabelpos = new PixelPosition(0, 42);
    private final TextZone east;
    private static final PixelPosition eastpos = new PixelPosition(70, 42);
    private final TextZone depthlabel;
    private static final PixelPosition depthlabelpos = new PixelPosition(0, 60);
    private final TextZone depth;
    private static final PixelPosition depthpos = new PixelPosition(70, 60);
    private final TextZone hDOP;
    private static final PixelPosition hDOPpos = new PixelPosition(8, 79);
    private static final CharacterArea hDOParea = new CharacterArea(6, 1);
    private final VariableLogBarWidget hDOPbar;
    private static final PixelPosition hDOPbarpos = new PixelPosition(50, 78);
    private static final PixelArea hDOPbararea = new PixelArea(101, 10);
    private final TextZone confirm;
    private static final PixelPosition confirmpos = new PixelPosition(0, 95);
    private final boolean displaydepth;

    public ConfirmAtReferenceLocationScreen(SerialTFTDisplay display, boolean displaydepth) throws IOException {
        super("confirm at reference location", display);
        this.displaydepth = displaydepth;
        this.header = new TextZone(display, headerpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setForeground(SerialTFTDisplay.Colour.GREEN).setCentre();
        this.addZone((Zone)this.header);
        this.header.insert("Reference Location");
        this.confirm = new TextZone(display, confirmpos, fullwidthx2, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setForeground(SerialTFTDisplay.Colour.RED).setCentre();
        this.addZone((Zone)this.confirm);
        this.confirm.insert("Press Select to confirm");
        this.northlabel = new TextZone(display, northlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.northlabel);
        this.northlabel.insert("North: ");
        this.north = new TextZone(display, northpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.north);
        this.eastlabel = new TextZone(display, eastlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.eastlabel);
        this.eastlabel.insert("East: ");
        this.east = new TextZone(display, eastpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.east);
        this.depthlabel = new TextZone(display, depthlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.depthlabel);
        this.depthlabel.insert(displaydepth ? "Depth: " : "Altitude: ");
        this.depth = new TextZone(display, depthpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.depth);
        this.hDOP = new TextZone(display, hDOPpos, hDOParea, SerialTFTDisplay.Font.SIZE_6x12, SerialTFTDisplay.CharSet.ISO_8859_1);
        this.addZone((Zone)this.hDOP);
        this.hDOPbar = new VariableLogBarWidget(display, hDOPbarpos, hDOPbararea, 1.0, 6.0, SerialTFTDisplay.Colour.GREEN, SerialTFTDisplay.Colour.YELLOW, true);
        this.addZone((Zone)this.hDOPbar);
    }

    protected void hasGainedFocus() throws IOException {
        this.dataChanged(Controller.getLocationData());
    }

    @Override
    public boolean actionOnButton(IRControlAction.Button button) throws IOException {
        Reporting.report((String)"Screen", (int)3, (String)"ConfirmAtReferenceLocation processing command %s", (Object)((Object)button));
        if (button == IRControlAction.Button.SELECT) {
            View.displayNextScreen();
            return true;
        }
        return false;
    }

    @Override
    public void dataChanged(LocationData ld) throws IOException {
        LocationData.Location l = ld.getLocation();
        HDOP hdop = l.getHDOP();
        this.hDOP.insert(hdop.toString());
        this.hDOPbar.setValue(hdop.get());
        this.north.insert(l.getPosition().latitude.toStringWithUnits());
        this.east.insert(l.getPosition().longitude.toStringWithUnits());
        this.depth.insert(this.displaydepth ? l.getDepth().toStringWithUnits() : l.getAltitude().toStringWithUnits());
        this.paint();
    }
}

