/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.gpssurvey.ui.ScreenDataChangeProcessor;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;

public class HeadingScreen
extends Screen
implements ScreenDataChangeProcessor {
    private static final HybridArea fullwidthx1 = new HybridArea(160, 1);
    private final TextZone header1;
    private static final PixelPosition header1pos = new PixelPosition(0, 0);
    private final TextZone course;
    private static final PixelPosition coursepos = new PixelPosition(0, 27);
    private final TextZone header2;
    private static final PixelPosition header2pos = new PixelPosition(0, 64);
    private final TextZone speed;
    private static final PixelPosition speedpos = new PixelPosition(0, 91);
    private final boolean displayknots;

    public HeadingScreen(SerialTFTDisplay display, boolean displayknots) throws IOException {
        super("position", display);
        this.displayknots = displayknots;
        this.header1 = new TextZone(display, header1pos, fullwidthx1, SerialTFTDisplay.Font.SIZE_10x20, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.header1);
        this.header1.insert("HEADING");
        this.course = new TextZone(display, coursepos, fullwidthx1, SerialTFTDisplay.Font.SIZE_15x30, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre();
        this.addZone((Zone)this.course);
        this.header2 = new TextZone(display, header2pos, fullwidthx1, SerialTFTDisplay.Font.SIZE_10x20, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.header2);
        this.header2.insert("SPEED " + (displayknots ? "(Kt)" : "(m/s)"));
        this.speed = new TextZone(display, speedpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_15x30, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre();
        this.addZone((Zone)this.speed);
    }

    protected void hasGainedFocus() throws IOException {
        this.dataChanged(Controller.getLocationData());
    }

    @Override
    public void dataChanged(LocationData ld) throws IOException {
        this.course.insert(String.format("%3.0f", ld.getHeading()).trim());
        this.speed.insert((this.displayknots ? String.format("%4.1f", ld.getKnots()) : String.format("%4.1f", ld.getSpeed())).trim());
        this.paint();
    }
}

