/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.HDOP;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.gpssurvey.ui.ScreenDataChangeProcessor;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.CharacterArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.VariableLogBarWidget;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;

public class LocationScreen
extends Screen
implements ScreenDataChangeProcessor {
    private static final int LABELWIDTH = 70;
    private static final HybridArea halfwidthx1 = new HybridArea(80, 1);
    private static final HybridArea fullwidthx1 = new HybridArea(160, 1);
    private static final HybridArea labelwidthx1 = new HybridArea(70, 1);
    private static final HybridArea fieldwidthx1 = new HybridArea(90, 1);
    private final TextZone header;
    private static final PixelPosition headerpos = new PixelPosition(0, 0);
    private final TextZone northlabel;
    private static final PixelPosition northlabelpos = new PixelPosition(0, 24);
    private final TextZone north;
    private static final PixelPosition northpos = new PixelPosition(70, 24);
    private final TextZone eastlabel;
    private static final PixelPosition eastlabelpos = new PixelPosition(0, 42);
    private final TextZone east;
    private static final PixelPosition eastPos = new PixelPosition(70, 42);
    private final TextZone depthlabel;
    private static final PixelPosition depthlabelpos = new PixelPosition(0, 60);
    private final TextZone depth;
    private static final PixelPosition depthpos = new PixelPosition(70, 60);
    private final TextZone hDOP;
    private static final PixelPosition hDOPpos = new PixelPosition(8, 101);
    private static final CharacterArea hDOParea = new CharacterArea(6, 1);
    private final VariableLogBarWidget hDOPbar;
    private static final PixelPosition hDOPbarpos = new PixelPosition(50, 100);
    private static final PixelArea hDOPbararea = new PixelArea(101, 10);
    private final TextZone time;
    private static final PixelPosition timepos = new PixelPosition(80, 114);
    private final TextZone date;
    private static final PixelPosition datepos = new PixelPosition(0, 114);
    private final boolean displaycoordinates;
    private final boolean displaydepth;

    public LocationScreen(SerialTFTDisplay display, boolean displaycoordinates, boolean displaydepth) throws IOException {
        super("location", display);
        this.displaycoordinates = displaycoordinates;
        this.displaydepth = displaydepth;
        this.header = new TextZone(display, headerpos, fullwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1, 0, 4).setCentre().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.header);
        this.header.insert("Current Location");
        this.northlabel = new TextZone(display, northlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.northlabel);
        this.northlabel.insert("North: ");
        this.north = new TextZone(display, northpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.north);
        this.eastlabel = new TextZone(display, eastlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.eastlabel);
        this.eastlabel.insert("East: ");
        this.east = new TextZone(display, eastPos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.east);
        this.depthlabel = new TextZone(display, depthlabelpos, labelwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.depthlabel);
        this.depthlabel.insert(displaydepth ? "Depth: " : "Altitude: ");
        this.depth = new TextZone(display, depthpos, fieldwidthx1, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setRight();
        this.addZone((Zone)this.depth);
        this.hDOP = new TextZone(display, hDOPpos, hDOParea, SerialTFTDisplay.Font.SIZE_6x12, SerialTFTDisplay.CharSet.ISO_8859_1);
        this.addZone((Zone)this.hDOP);
        this.hDOPbar = new VariableLogBarWidget(display, hDOPbarpos, hDOPbararea, 1.0, 6.0, SerialTFTDisplay.Colour.GREEN, SerialTFTDisplay.Colour.YELLOW, true);
        this.addZone((Zone)this.hDOPbar);
        this.date = new TextZone(display, datepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_6x12, SerialTFTDisplay.CharSet.ISO_8859_1).setLeft().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.date);
        this.time = new TextZone(display, timepos, halfwidthx1, SerialTFTDisplay.Font.SIZE_6x12, SerialTFTDisplay.CharSet.ISO_8859_1).setRight().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.time);
    }

    protected void hasGainedFocus() throws IOException {
        this.dataChanged(Controller.getLocationData());
    }

    @Override
    public void dataChanged(LocationData ld) throws IOException {
        LocationData.Location l = ld.getLocation();
        this.date.insert(ld.getDatedisplay());
        this.time.insert(ld.getTimedisplay());
        if (l != null) {
            HDOP hdop = l.getHDOP();
            this.hDOP.insert(hdop.toString());
            this.hDOPbar.setValue(hdop.get());
            this.east.insert(this.displaycoordinates ? l.getPosition().x.toStringWithUnits() : l.getPosition().longitude.toStringWithUnits());
            this.north.insert(this.displaycoordinates ? l.getPosition().y.toStringWithUnits() : l.getPosition().latitude.toStringWithUnits());
            this.depth.insert(this.displaydepth ? l.getDepth().toStringWithUnits() : l.getAltitude().toStringWithUnits());
        }
        this.paint();
    }
}

