/*
 * Decompiled with CFR 0.152.
 */
package uk.theretiredprogrammer.gpssurvey.uiscreens;

import java.io.IOException;
import uk.theretiredprogrammer.gpssurvey.Position;
import uk.theretiredprogrammer.gpssurvey.informationstore.Controller;
import uk.theretiredprogrammer.gpssurvey.informationstore.LocationData;
import uk.theretiredprogrammer.gpssurvey.ui.ScreenDataChangeProcessor;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.HybridArea;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.PixelPosition;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Screen;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.SerialTFTDisplay;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.TextZone;
import uk.theretiredprogrammer.rpiembeddedlibrary.screen.Zone;

public class PointDisplayScreen
extends Screen
implements ScreenDataChangeProcessor {
    private static final HybridArea fullwidthx3 = new HybridArea(160, 3);
    private static final HybridArea fullwidthx6 = new HybridArea(160, 6);
    private final TextZone header;
    private static final PixelPosition headerpos = new PixelPosition(0, 2);
    private final TextZone pointinformation;
    private static final PixelPosition pointinformationpos = new PixelPosition(0, 44);

    public PointDisplayScreen(SerialTFTDisplay display) throws IOException {
        super("position", display);
        this.header = new TextZone(display, headerpos, fullwidthx3, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1).setCentre().setForeground(SerialTFTDisplay.Colour.GREEN);
        this.addZone((Zone)this.header);
        this.header.insert("Course and Distance from Current To Recorded Pts");
        this.pointinformation = new TextZone(display, pointinformationpos, fullwidthx6, SerialTFTDisplay.Font.SIZE_7x14, SerialTFTDisplay.CharSet.ISO_8859_1);
        this.addZone((Zone)this.pointinformation);
    }

    protected void hasGainedFocus() throws IOException {
        this.dataChanged(Controller.getLocationData());
    }

    @Override
    public void dataChanged(LocationData ld) throws IOException {
        int pointcount = ld.getPointsSize();
        StringBuffer sb = new StringBuffer();
        for (int linecount = 6; linecount > 0 && pointcount > 0; --linecount) {
            this.addPolarDisplay(sb, ld.getCurrentFromPoint(--pointcount));
        }
        this.pointinformation.insert(sb.toString());
        this.paint();
    }

    private void addPolarDisplay(StringBuffer sb, Position p) {
        sb.append(String.format("%s %s\n", p.distance.toStringWithUnits(), p.course.toStringWithUnits()));
    }
}

